/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.cache.FileCacheStore;
import org.apache.dubbo.common.cache.FileCacheStoreFactory;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.resource.Disposable;
import org.apache.dubbo.common.utils.JsonUtils;
import org.apache.dubbo.common.utils.LRUCache;
import org.apache.dubbo.common.utils.NamedThreadFactory;

public abstract class AbstractCacheManager<V>
implements Disposable {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ScheduledExecutorService executorService;
    protected FileCacheStore cacheStore;
    protected LRUCache<String, V> cache;

    protected void init(String filePath, String fileName, int entrySize, long fileSize, int interval, ScheduledExecutorService executorService) {
        this.cache = new LRUCache(entrySize);
        try {
            this.cacheStore = FileCacheStoreFactory.getInstance((String)filePath, (String)fileName);
            Map properties = this.cacheStore.loadCache(entrySize);
            this.logger.info("Successfully loaded mapping cache from file " + fileName + ", entries " + properties.size());
            for (Map.Entry entry : properties.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                this.cache.put((Object)key, this.toValueType(value));
            }
            this.executorService = executorService == null ? Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("Dubbo-cache-refreshing-scheduler", true)) : executorService;
            this.executorService.scheduleWithFixedDelay(new CacheRefreshTask<V>(this.cacheStore, this.cache, this, fileSize), 10L, interval, TimeUnit.MINUTES);
        }
        catch (Exception e) {
            this.logger.error("Load mapping from local cache file error ", (Throwable)e);
        }
    }

    protected abstract V toValueType(String var1);

    protected abstract String getName();

    public V get(String key) {
        return (V)this.cache.get((Object)key);
    }

    public void put(String key, V apps) {
        this.cache.put((Object)key, apps);
    }

    public V remove(String key) {
        return (V)this.cache.remove((Object)key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, V> getAll() {
        if (this.cache.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap copyMap = new HashMap();
        this.cache.lock();
        try {
            for (Map.Entry entry : this.cache.entrySet()) {
                copyMap.put((String)entry.getKey(), entry.getValue());
            }
        }
        finally {
            this.cache.releaseLock();
        }
        return Collections.unmodifiableMap(copyMap);
    }

    public void update(Map<String, V> newCache) {
        for (Map.Entry<String, V> entry : newCache.entrySet()) {
            this.cache.put((Object)entry.getKey(), entry.getValue());
        }
    }

    public void destroy() {
        if (this.executorService != null) {
            this.executorService.shutdownNow();
        }
        if (this.cacheStore != null) {
            this.cacheStore.destroy();
        }
        if (this.cache != null) {
            this.cache.clear();
        }
    }

    public FileCacheStore getCacheStore() {
        return this.cacheStore;
    }

    public LRUCache<String, V> getCache() {
        return this.cache;
    }

    public static class CacheRefreshTask<V>
    implements Runnable {
        private final Logger logger = LoggerFactory.getLogger(this.getClass());
        private static final String DEFAULT_COMMENT = "Dubbo cache";
        private final FileCacheStore cacheStore;
        private final LRUCache<String, V> cache;
        private final AbstractCacheManager<V> cacheManager;
        private final long maxFileSize;

        public CacheRefreshTask(FileCacheStore cacheStore, LRUCache<String, V> cache, AbstractCacheManager<V> cacheManager, long maxFileSize) {
            this.cacheStore = cacheStore;
            this.cache = cache;
            this.cacheManager = cacheManager;
            this.maxFileSize = maxFileSize;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            HashMap<String, String> properties = new HashMap<String, String>();
            this.cache.lock();
            try {
                for (Map.Entry entry : this.cache.entrySet()) {
                    properties.put((String)entry.getKey(), JsonUtils.getJson().toJson(entry.getValue()));
                }
            }
            finally {
                this.cache.releaseLock();
            }
            this.logger.info("Dumping " + this.cacheManager.getName() + " caches, latest entries " + properties.size());
            this.cacheStore.refreshCache(properties, DEFAULT_COMMENT, this.maxFileSize);
        }
    }
}

