/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.threadpool.manager.FrameworkExecutorRepository;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.metadata.MappingCacheManager;
import org.apache.dubbo.metadata.MappingChangedEvent;
import org.apache.dubbo.metadata.MappingListener;
import org.apache.dubbo.metadata.ServiceNameMapping;
import org.apache.dubbo.rpc.model.ApplicationModel;

public abstract class AbstractServiceNameMapping
implements ServiceNameMapping {
    protected final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(this.getClass());
    protected ApplicationModel applicationModel;
    private final MappingCacheManager mappingCacheManager;
    private final Map<String, Set<MappingListener>> mappingListeners = new ConcurrentHashMap<String, Set<MappingListener>>();
    private final ConcurrentMap<String, ReentrantLock> mappingLocks = new ConcurrentHashMap<String, ReentrantLock>();
    private final Map<String, Boolean> mappingInitStatus = new HashMap<String, Boolean>();

    public AbstractServiceNameMapping(ApplicationModel applicationModel) {
        this.applicationModel = applicationModel;
        boolean enableFileCache = true;
        Optional application = applicationModel.getApplicationConfigManager().getApplication();
        if (application.isPresent()) {
            enableFileCache = Boolean.TRUE.equals(((ApplicationConfig)application.get()).getEnableFileCache());
        }
        this.mappingCacheManager = new MappingCacheManager(enableFileCache, applicationModel.tryGetApplicationName(), ((FrameworkExecutorRepository)applicationModel.getFrameworkModel().getBeanFactory().getBean(FrameworkExecutorRepository.class)).getCacheRefreshingScheduledExecutor());
    }

    public void setApplicationModel(ApplicationModel applicationModel) {
        this.applicationModel = applicationModel;
    }

    public abstract Set<String> get(URL var1);

    public abstract Set<String> getAndListen(URL var1, MappingListener var2);

    protected abstract void removeListener(URL var1, MappingListener var2);

    @Override
    public synchronized void initInterfaceAppMapping(URL subscribedURL) {
        String key = ServiceNameMapping.buildMappingKey(subscribedURL);
        if (this.hasInitiated(key)) {
            return;
        }
        this.mappingInitStatus.put(key, Boolean.TRUE);
        TreeSet<String> subscribedServices = new TreeSet<String>();
        String serviceNames = subscribedURL.getParameter("provided-by");
        if (StringUtils.isNotEmpty((String)serviceNames)) {
            this.logger.info(key + " mapping to " + serviceNames + " instructed by provided-by set by user.");
            subscribedServices.addAll(AbstractServiceNameMapping.parseServices(serviceNames));
        }
        if (CollectionUtils.isEmpty(subscribedServices)) {
            Set<String> cachedServices = this.getCachedMapping(key);
            if (!CollectionUtils.isEmpty(cachedServices)) {
                this.logger.info(key + " mapping to " + serviceNames + " instructed by local cache.");
                subscribedServices.addAll(cachedServices);
            }
        } else {
            this.putCachedMappingIfAbsent(key, subscribedServices);
        }
    }

    @Override
    public Set<String> getAndListen(URL registryURL, URL subscribedURL, MappingListener listener) {
        String key = ServiceNameMapping.buildMappingKey(subscribedURL);
        Set<String> mappingServices = this.getCachedMapping(key);
        if (CollectionUtils.isEmpty(mappingServices)) {
            String registryServices;
            try {
                this.logger.info("Local cache mapping is empty");
                mappingServices = new AsyncMappingTask(listener, subscribedURL, false).call();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (CollectionUtils.isEmpty(mappingServices) && StringUtils.isNotEmpty((String)(registryServices = registryURL.getParameter("subscribed-services")))) {
                this.logger.info(subscribedURL.getServiceInterface() + " mapping to " + registryServices + " instructed by registry subscribed-services.");
                mappingServices = AbstractServiceNameMapping.parseServices(registryServices);
            }
            if (CollectionUtils.isNotEmpty(mappingServices)) {
                this.putCachedMapping(key, mappingServices);
            }
        } else {
            ExecutorService executorService = ((FrameworkExecutorRepository)this.applicationModel.getFrameworkModel().getBeanFactory().getBean(FrameworkExecutorRepository.class)).getMappingRefreshingExecutor();
            executorService.submit(new AsyncMappingTask(listener, subscribedURL, true));
        }
        return mappingServices;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MappingListener stopListen(URL subscribeURL, MappingListener listener) {
        Map<String, Set<MappingListener>> map = this.mappingListeners;
        synchronized (map) {
            String mappingKey = ServiceNameMapping.buildMappingKey(subscribeURL);
            Set<MappingListener> listeners = this.mappingListeners.get(mappingKey);
            if (CollectionUtils.isNotEmpty(listeners)) {
                listeners.remove(listener);
                listener.stop();
                this.removeListener(subscribeURL, listener);
            }
            if (CollectionUtils.isEmpty(listeners)) {
                this.mappingListeners.remove(mappingKey);
                this.removeCachedMapping(mappingKey);
                this.removeMappingLock(mappingKey);
            }
            return listener;
        }
    }

    static Set<String> parseServices(String literalServices) {
        return StringUtils.isBlank((CharSequence)literalServices) ? Collections.emptySet() : Collections.unmodifiableSet(new TreeSet(Stream.of(literalServices.split(",")).map(String::trim).filter(StringUtils::isNotEmpty).collect(Collectors.toSet())));
    }

    @Override
    public void putCachedMapping(String serviceKey, Set<String> apps) {
        this.mappingCacheManager.put(serviceKey, CollectionUtils.toTreeSet(apps));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putCachedMappingIfAbsent(String serviceKey, Set<String> apps) {
        Lock lock = this.getMappingLock(serviceKey);
        try {
            lock.lock();
            if (CollectionUtils.isEmpty((Collection)((Collection)this.mappingCacheManager.get(serviceKey)))) {
                this.mappingCacheManager.put(serviceKey, CollectionUtils.toTreeSet(apps));
            }
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public Set<String> getCachedMapping(String mappingKey) {
        return (Set)this.mappingCacheManager.get(mappingKey);
    }

    @Override
    public Set<String> getCachedMapping(URL consumerURL) {
        return this.getCachedMapping(ServiceNameMapping.buildMappingKey(consumerURL));
    }

    @Override
    public Set<String> getRemoteMapping(URL consumerURL) {
        return this.get(consumerURL);
    }

    @Override
    public Set<String> removeCachedMapping(String serviceKey) {
        return (Set)this.mappingCacheManager.remove(serviceKey);
    }

    @Override
    public Map<String, Set<String>> getCachedMapping() {
        return Collections.unmodifiableMap(this.mappingCacheManager.getAll());
    }

    public Lock getMappingLock(String key) {
        return this.mappingLocks.computeIfAbsent(key, _k -> new ReentrantLock());
    }

    protected void removeMappingLock(String key) {
        Lock lock = (Lock)this.mappingLocks.get(key);
        if (lock != null) {
            try {
                lock.lock();
                this.mappingLocks.remove(key);
            }
            finally {
                lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasInitiated(String key) {
        Lock lock = this.getMappingLock(key);
        try {
            lock.lock();
            boolean bl = this.mappingInitStatus.computeIfAbsent(key, _k -> Boolean.FALSE);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    public void $destroy() {
        this.mappingCacheManager.destroy();
        this.mappingListeners.clear();
        this.mappingLocks.clear();
        this.mappingInitStatus.clear();
    }

    private class AsyncMappingTask
    implements Callable<Set<String>> {
        private final MappingListener listener;
        private final URL subscribedURL;
        private final boolean notifyAtFirstTime;

        public AsyncMappingTask(MappingListener listener, URL subscribedURL, boolean notifyAtFirstTime) {
            this.listener = listener;
            this.subscribedURL = subscribedURL;
            this.notifyAtFirstTime = notifyAtFirstTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<String> call() throws Exception {
            Map map = AbstractServiceNameMapping.this.mappingListeners;
            synchronized (map) {
                Set<String> mappedServices = Collections.emptySet();
                try {
                    String mappingKey = ServiceNameMapping.buildMappingKey(this.subscribedURL);
                    if (this.listener != null) {
                        mappedServices = CollectionUtils.toTreeSet(AbstractServiceNameMapping.this.getAndListen(this.subscribedURL, this.listener));
                        Set listeners = AbstractServiceNameMapping.this.mappingListeners.computeIfAbsent(mappingKey, _k -> new HashSet());
                        listeners.add(this.listener);
                        if (CollectionUtils.isNotEmpty((Collection)mappedServices) && this.notifyAtFirstTime) {
                            this.listener.onEvent(new MappingChangedEvent(mappingKey, mappedServices));
                        }
                    } else {
                        mappedServices = AbstractServiceNameMapping.this.get(this.subscribedURL);
                        if (CollectionUtils.isNotEmpty(mappedServices)) {
                            AbstractServiceNameMapping.this.putCachedMapping(mappingKey, mappedServices);
                        }
                    }
                }
                catch (Exception e) {
                    AbstractServiceNameMapping.this.logger.error("0-24", "", "", "Failed getting mapping info from remote center. ", (Throwable)e);
                }
                return mappedServices;
            }
        }
    }
}

