/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.rest.springmvc;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.dubbo.common.utils.AnnotationUtils;
import org.apache.dubbo.common.utils.ArrayUtils;
import org.apache.dubbo.common.utils.MethodUtils;
import org.apache.dubbo.common.utils.PathUtils;
import org.apache.dubbo.metadata.rest.AbstractServiceRestMetadataResolver;
import org.apache.dubbo.metadata.rest.RestMetadataConstants;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class SpringMvcServiceRestMetadataResolver
extends AbstractServiceRestMetadataResolver {
    private static final int FIRST_ELEMENT_INDEX = 0;

    public SpringMvcServiceRestMetadataResolver(ApplicationModel applicationModel) {
        super(applicationModel);
    }

    @Override
    protected boolean supports0(Class<?> serviceType) {
        return AnnotationUtils.isAnnotationPresent(serviceType, RestMetadataConstants.SPRING_MVC.CONTROLLER_ANNOTATION_CLASS);
    }

    @Override
    protected boolean isRestCapableMethod(Method serviceMethod, Class<?> serviceType, Class<?> serviceInterfaceClass) {
        return AnnotationUtils.isAnnotationPresent(serviceType, RestMetadataConstants.SPRING_MVC.REQUEST_MAPPING_ANNOTATION_CLASS) || AnnotationUtils.isAnnotationPresent((AnnotatedElement)serviceMethod, RestMetadataConstants.SPRING_MVC.REQUEST_MAPPING_ANNOTATION_CLASS);
    }

    @Override
    protected String resolveRequestMethod(Method serviceMethod, Class<?> serviceType, Class<?> serviceInterfaceClass) {
        Annotation requestMapping = this.getRequestMapping(serviceMethod);
        Object httpMethod = AnnotationUtils.getAttribute((Annotation)requestMapping, (String)"method");
        if (httpMethod == null || Array.getLength(httpMethod) < 1) {
            return null;
        }
        return String.valueOf(Array.get(httpMethod, 0));
    }

    @Override
    protected String resolveRequestPath(Method serviceMethod, Class<?> serviceType, Class<?> serviceInterfaceClass) {
        String requestBasePath = this.resolveRequestPath(serviceType);
        String requestRelativePath = this.resolveRequestPath(serviceMethod);
        return PathUtils.buildPath((String)requestBasePath, (String[])new String[]{requestRelativePath});
    }

    @Override
    protected void processProduces(Method serviceMethod, Class<?> serviceType, Class<?> serviceInterfaceClass, Set<String> produces) {
        this.addMediaTypes(serviceMethod, "produces", produces);
    }

    @Override
    protected void processConsumes(Method serviceMethod, Class<?> serviceType, Class<?> serviceInterfaceClass, Set<String> consumes) {
        this.addMediaTypes(serviceMethod, "consumes", consumes);
    }

    private String resolveRequestPath(AnnotatedElement annotatedElement) {
        Annotation mappingAnnotation = this.getRequestMapping(annotatedElement);
        Object[] value = (String[])AnnotationUtils.getAttribute((Annotation)mappingAnnotation, (String)"value");
        if (ArrayUtils.isEmpty((Object[])value)) {
            value = (String[])AnnotationUtils.getAttribute((Annotation)mappingAnnotation, (String)"path");
        }
        if (ArrayUtils.isEmpty((Object[])value)) {
            return "";
        }
        return value[0];
    }

    private void addMediaTypes(Method serviceMethod, String annotationAttributeName, Set<String> mediaTypesSet) {
        Annotation mappingAnnotation = this.getRequestMapping(serviceMethod);
        Object[] mediaTypes = (String[])AnnotationUtils.getAttribute((Annotation)mappingAnnotation, (String)annotationAttributeName);
        if (ArrayUtils.isNotEmpty((Object[])mediaTypes)) {
            Stream.of(mediaTypes).forEach(mediaTypesSet::add);
        }
    }

    private Annotation getRequestMapping(AnnotatedElement annotatedElement) {
        Method method;
        Annotation requestMapping = AnnotationUtils.findAnnotation((AnnotatedElement)annotatedElement, RestMetadataConstants.SPRING_MVC.REQUEST_MAPPING_ANNOTATION_CLASS);
        if (requestMapping == null && (method = MethodUtils.findMethod(RestMetadataConstants.SPRING_MVC.ANNOTATED_ELEMENT_UTILS_CLASS, (String)"findMergedAnnotation", (Class[])new Class[]{AnnotatedElement.class, Class.class})) != null) {
            try {
                requestMapping = (Annotation)method.invoke(null, annotatedElement, RestMetadataConstants.SPRING_MVC.REQUEST_MAPPING_ANNOTATION_CLASS);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return requestMapping;
    }
}

