/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.report.support;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.ConfigUtils;
import org.apache.dubbo.common.utils.JsonUtils;
import org.apache.dubbo.common.utils.NamedThreadFactory;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.metadata.definition.model.FullServiceDefinition;
import org.apache.dubbo.metadata.definition.model.ServiceDefinition;
import org.apache.dubbo.metadata.report.MetadataReport;
import org.apache.dubbo.metadata.report.identifier.KeyTypeEnum;
import org.apache.dubbo.metadata.report.identifier.MetadataIdentifier;
import org.apache.dubbo.metadata.report.identifier.ServiceMetadataIdentifier;
import org.apache.dubbo.metadata.report.identifier.SubscriberMetadataIdentifier;
import org.apache.dubbo.metadata.report.support.Constants;
import org.apache.dubbo.metrics.event.MetricsEvent;
import org.apache.dubbo.metrics.event.MetricsEventBus;
import org.apache.dubbo.metrics.metadata.event.MetadataEvent;
import org.apache.dubbo.rpc.model.ApplicationModel;

public abstract class AbstractMetadataReport
implements MetadataReport {
    protected static final String DEFAULT_ROOT = "dubbo";
    private static final int ONE_DAY_IN_MILLISECONDS = 86400000;
    private static final int FOUR_HOURS_IN_MILLISECONDS = 14400000;
    protected final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(this.getClass());
    final Properties properties = new Properties();
    private final ExecutorService reportCacheExecutor = Executors.newFixedThreadPool(1, (ThreadFactory)new NamedThreadFactory("DubboSaveMetadataReport", true));
    final Map<MetadataIdentifier, Object> allMetadataReports = new ConcurrentHashMap<MetadataIdentifier, Object>(4);
    private final AtomicLong lastCacheChanged = new AtomicLong();
    final Map<MetadataIdentifier, Object> failedReports = new ConcurrentHashMap<MetadataIdentifier, Object>(4);
    private URL reportURL;
    boolean syncReport;
    File file;
    private AtomicBoolean initialized = new AtomicBoolean(false);
    public MetadataReportRetry metadataReportRetry;
    private ScheduledExecutorService reportTimerScheduler;
    private final boolean reportMetadata;
    private final boolean reportDefinition;
    protected ApplicationModel applicationModel;

    public AbstractMetadataReport(URL reportServerURL) {
        this.setUrl(reportServerURL);
        this.applicationModel = reportServerURL.getOrDefaultApplicationModel();
        boolean localCacheEnabled = reportServerURL.getParameter("file-cache", true);
        String defaultFilename = System.getProperty("user.home") + "/.dubbo/dubbo-metadata-" + reportServerURL.getApplication() + "-" + StringUtils.replace((String)reportServerURL.getAddress(), (String)":", (String)"-") + ".cache";
        String filename = reportServerURL.getParameter("file", defaultFilename);
        File file = null;
        if (localCacheEnabled && ConfigUtils.isNotEmpty((String)filename)) {
            file = new File(filename);
            if (!(file.exists() || file.getParentFile() == null || file.getParentFile().exists() || file.getParentFile().mkdirs())) {
                throw new IllegalArgumentException("Invalid service store file " + file + ", cause: Failed to create directory " + file.getParentFile() + "!");
            }
            if (!this.initialized.getAndSet(true) && file.exists()) {
                file.delete();
            }
        }
        this.file = file;
        this.loadProperties();
        this.syncReport = reportServerURL.getParameter("sync-report", false);
        this.metadataReportRetry = new MetadataReportRetry(reportServerURL.getParameter("retry-times", Constants.DEFAULT_METADATA_REPORT_RETRY_TIMES.intValue()), reportServerURL.getParameter("retry-period", Constants.DEFAULT_METADATA_REPORT_RETRY_PERIOD.intValue()));
        if (reportServerURL.getParameter("cycle-report", Constants.DEFAULT_METADATA_REPORT_CYCLE_REPORT.booleanValue())) {
            this.reportTimerScheduler = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("DubboMetadataReportTimer", true));
            this.reportTimerScheduler.scheduleAtFixedRate(this::publishAll, this.calculateStartTime(), 86400000L, TimeUnit.MILLISECONDS);
        }
        this.reportMetadata = reportServerURL.getParameter("report-metadata", false);
        this.reportDefinition = reportServerURL.getParameter("report-definition", true);
    }

    public URL getUrl() {
        return this.reportURL;
    }

    protected void setUrl(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("metadataReport url == null");
        }
        this.reportURL = url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSaveProperties(long version) {
        if (version < this.lastCacheChanged.get()) {
            return;
        }
        if (this.file == null) {
            return;
        }
        try {
            File lockfile = new File(this.file.getAbsolutePath() + ".lock");
            if (!lockfile.exists()) {
                lockfile.createNewFile();
            }
            try (RandomAccessFile raf = new RandomAccessFile(lockfile, "rw");
                 FileChannel channel = raf.getChannel();){
                FileLock lock = channel.tryLock();
                if (lock == null) {
                    throw new IOException("Can not lock the metadataReport cache file " + this.file.getAbsolutePath() + ", ignore and retry later, maybe multi java process use the file, please config: dubbo.metadata.file=xxx.properties");
                }
                try {
                    Properties tmpProperties;
                    if (!this.file.exists()) {
                        this.file.createNewFile();
                    }
                    if (!this.syncReport) {
                        tmpProperties = this.properties;
                    } else {
                        tmpProperties = new Properties();
                        Set<Map.Entry<Object, Object>> entries = this.properties.entrySet();
                        for (Map.Entry<Object, Object> entry : entries) {
                            tmpProperties.setProperty((String)entry.getKey(), (String)entry.getValue());
                        }
                    }
                    try (FileOutputStream outputFile = new FileOutputStream(this.file);){
                        tmpProperties.store(outputFile, "Dubbo metadataReport Cache");
                    }
                }
                finally {
                    lock.release();
                }
            }
        }
        catch (Throwable e) {
            if (version < this.lastCacheChanged.get()) {
                return;
            }
            this.reportCacheExecutor.execute(new SaveProperties(this.lastCacheChanged.incrementAndGet()));
            this.logger.warn("0-12", "", "", "Failed to save service store file, cause: " + e.getMessage(), e);
        }
    }

    void loadProperties() {
        if (this.file != null && this.file.exists()) {
            try (FileInputStream in = new FileInputStream(this.file);){
                this.properties.load(in);
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Load service store file " + this.file + ", data: " + this.properties);
                }
            }
            catch (Throwable e) {
                this.logger.warn("0-12", "", "", "Failed to load service store file" + this.file, e);
            }
        }
    }

    private void saveProperties(MetadataIdentifier metadataIdentifier, String value, boolean add, boolean sync) {
        if (this.file == null) {
            return;
        }
        try {
            if (add) {
                this.properties.setProperty(metadataIdentifier.getUniqueKey(KeyTypeEnum.UNIQUE_KEY), value);
            } else {
                this.properties.remove(metadataIdentifier.getUniqueKey(KeyTypeEnum.UNIQUE_KEY));
            }
            long version = this.lastCacheChanged.incrementAndGet();
            if (sync) {
                new SaveProperties(version).run();
            } else {
                this.reportCacheExecutor.execute(new SaveProperties(version));
            }
        }
        catch (Throwable t) {
            this.logger.warn("0-12", "", "", t.getMessage(), t);
        }
    }

    public String toString() {
        return this.getUrl().toString();
    }

    @Override
    public void storeProviderMetadata(MetadataIdentifier providerMetadataIdentifier, ServiceDefinition serviceDefinition) {
        if (this.syncReport) {
            this.storeProviderMetadataTask(providerMetadataIdentifier, serviceDefinition);
        } else {
            this.reportCacheExecutor.execute(() -> this.storeProviderMetadataTask(providerMetadataIdentifier, serviceDefinition));
        }
    }

    private void storeProviderMetadataTask(MetadataIdentifier providerMetadataIdentifier, ServiceDefinition serviceDefinition) {
        MetadataEvent metadataEvent = MetadataEvent.toServiceSubscribeEvent((ApplicationModel)this.applicationModel, (String)providerMetadataIdentifier.getUniqueServiceName());
        MetricsEventBus.post((MetricsEvent)metadataEvent, () -> {
            boolean result = true;
            try {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("store provider metadata. Identifier : " + providerMetadataIdentifier + "; definition: " + serviceDefinition);
                }
                this.allMetadataReports.put(providerMetadataIdentifier, serviceDefinition);
                this.failedReports.remove(providerMetadataIdentifier);
                String data = JsonUtils.toJson((Object)serviceDefinition);
                this.doStoreProviderMetadata(providerMetadataIdentifier, data);
                this.saveProperties(providerMetadataIdentifier, data, true, !this.syncReport);
            }
            catch (Exception e) {
                this.failedReports.put(providerMetadataIdentifier, serviceDefinition);
                this.metadataReportRetry.startRetryTask();
                this.logger.error("3-2", "", "", "Failed to put provider metadata " + providerMetadataIdentifier + " in  " + serviceDefinition + ", cause: " + e.getMessage(), (Throwable)e);
                result = false;
            }
            return result;
        }, aBoolean -> aBoolean);
    }

    @Override
    public void storeConsumerMetadata(MetadataIdentifier consumerMetadataIdentifier, Map<String, String> serviceParameterMap) {
        if (this.syncReport) {
            this.storeConsumerMetadataTask(consumerMetadataIdentifier, serviceParameterMap);
        } else {
            this.reportCacheExecutor.execute(() -> this.storeConsumerMetadataTask(consumerMetadataIdentifier, serviceParameterMap));
        }
    }

    protected void storeConsumerMetadataTask(MetadataIdentifier consumerMetadataIdentifier, Map<String, String> serviceParameterMap) {
        try {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("store consumer metadata. Identifier : " + consumerMetadataIdentifier + "; definition: " + serviceParameterMap);
            }
            this.allMetadataReports.put(consumerMetadataIdentifier, serviceParameterMap);
            this.failedReports.remove(consumerMetadataIdentifier);
            String data = JsonUtils.toJson(serviceParameterMap);
            this.doStoreConsumerMetadata(consumerMetadataIdentifier, data);
            this.saveProperties(consumerMetadataIdentifier, data, true, !this.syncReport);
        }
        catch (Exception e) {
            this.failedReports.put(consumerMetadataIdentifier, serviceParameterMap);
            this.metadataReportRetry.startRetryTask();
            this.logger.error("3-2", "", "", "Failed to put consumer metadata " + consumerMetadataIdentifier + ";  " + serviceParameterMap + ", cause: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void destroy() {
        if (this.reportCacheExecutor != null) {
            this.reportCacheExecutor.shutdown();
        }
        if (this.reportTimerScheduler != null) {
            this.reportTimerScheduler.shutdown();
        }
        if (this.metadataReportRetry != null) {
            this.metadataReportRetry.destroy();
            this.metadataReportRetry = null;
        }
    }

    @Override
    public void saveServiceMetadata(ServiceMetadataIdentifier metadataIdentifier, URL url) {
        if (this.syncReport) {
            this.doSaveMetadata(metadataIdentifier, url);
        } else {
            this.reportCacheExecutor.execute(() -> this.doSaveMetadata(metadataIdentifier, url));
        }
    }

    @Override
    public void removeServiceMetadata(ServiceMetadataIdentifier metadataIdentifier) {
        if (this.syncReport) {
            this.doRemoveMetadata(metadataIdentifier);
        } else {
            this.reportCacheExecutor.execute(() -> this.doRemoveMetadata(metadataIdentifier));
        }
    }

    @Override
    public List<String> getExportedURLs(ServiceMetadataIdentifier metadataIdentifier) {
        return this.doGetExportedURLs(metadataIdentifier);
    }

    @Override
    public void saveSubscribedData(SubscriberMetadataIdentifier subscriberMetadataIdentifier, Set<String> urls) {
        if (this.syncReport) {
            this.doSaveSubscriberData(subscriberMetadataIdentifier, JsonUtils.toJson(urls));
        } else {
            this.reportCacheExecutor.execute(() -> this.doSaveSubscriberData(subscriberMetadataIdentifier, JsonUtils.toJson((Object)urls)));
        }
    }

    @Override
    public List<String> getSubscribedURLs(SubscriberMetadataIdentifier subscriberMetadataIdentifier) {
        String content = this.doGetSubscribedURLs(subscriberMetadataIdentifier);
        return JsonUtils.toJavaList((String)content, String.class);
    }

    String getProtocol(URL url) {
        String protocol = url.getSide();
        protocol = protocol == null ? url.getProtocol() : protocol;
        return protocol;
    }

    public boolean retry() {
        return this.doHandleMetadataCollection(this.failedReports);
    }

    @Override
    public boolean shouldReportDefinition() {
        return this.reportDefinition;
    }

    @Override
    public boolean shouldReportMetadata() {
        return this.reportMetadata;
    }

    private boolean doHandleMetadataCollection(Map<MetadataIdentifier, Object> metadataMap) {
        if (metadataMap.isEmpty()) {
            return true;
        }
        for (Map.Entry<MetadataIdentifier, Object> item : metadataMap.entrySet()) {
            if ("provider".equals(item.getKey().getSide())) {
                this.storeProviderMetadata(item.getKey(), (ServiceDefinition)((FullServiceDefinition)item.getValue()));
                continue;
            }
            if (!"consumer".equals(item.getKey().getSide())) continue;
            this.storeConsumerMetadata(item.getKey(), (Map)item.getValue());
        }
        return false;
    }

    void publishAll() {
        this.logger.info("start to publish all metadata.");
        this.doHandleMetadataCollection(this.allMetadataReports);
    }

    long calculateStartTime() {
        Calendar calendar = Calendar.getInstance();
        long nowMill = calendar.getTimeInMillis();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        long subtract = calendar.getTimeInMillis() + 86400000L - nowMill;
        return subtract + 0x6DDD00L + (long)ThreadLocalRandom.current().nextInt(14400000);
    }

    private void doSaveSubscriberData(SubscriberMetadataIdentifier subscriberMetadataIdentifier, List<String> urls) {
        if (CollectionUtils.isEmpty(urls)) {
            return;
        }
        ArrayList<String> encodedUrlList = new ArrayList<String>(urls.size());
        for (String url : urls) {
            encodedUrlList.add(URL.encode((String)url));
        }
        this.doSaveSubscriberData(subscriberMetadataIdentifier, encodedUrlList);
    }

    protected abstract void doStoreProviderMetadata(MetadataIdentifier var1, String var2);

    protected abstract void doStoreConsumerMetadata(MetadataIdentifier var1, String var2);

    protected abstract void doSaveMetadata(ServiceMetadataIdentifier var1, URL var2);

    protected abstract void doRemoveMetadata(ServiceMetadataIdentifier var1);

    protected abstract List<String> doGetExportedURLs(ServiceMetadataIdentifier var1);

    protected abstract void doSaveSubscriberData(SubscriberMetadataIdentifier var1, String var2);

    protected abstract String doGetSubscribedURLs(SubscriberMetadataIdentifier var1);

    @Deprecated
    protected ExecutorService getReportCacheExecutor() {
        return this.reportCacheExecutor;
    }

    @Deprecated
    protected MetadataReportRetry getMetadataReportRetry() {
        return this.metadataReportRetry;
    }

    class MetadataReportRetry {
        protected final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(this.getClass());
        final ScheduledExecutorService retryExecutor = Executors.newScheduledThreadPool(0, (ThreadFactory)new NamedThreadFactory("DubboMetadataReportRetryTimer", true));
        volatile ScheduledFuture retryScheduledFuture;
        final AtomicInteger retryCounter = new AtomicInteger(0);
        long retryPeriod;
        int retryTimesIfNonFail = 600;
        int retryLimit;

        public MetadataReportRetry(int retryTimes, int retryPeriod) {
            this.retryPeriod = retryPeriod;
            this.retryLimit = retryTimes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void startRetryTask() {
            if (this.retryScheduledFuture == null) {
                AtomicInteger atomicInteger = this.retryCounter;
                synchronized (atomicInteger) {
                    if (this.retryScheduledFuture == null) {
                        this.retryScheduledFuture = this.retryExecutor.scheduleWithFixedDelay(() -> {
                            try {
                                int times = this.retryCounter.incrementAndGet();
                                this.logger.info("start to retry task for metadata report. retry times:" + times);
                                if (AbstractMetadataReport.this.retry() && times > this.retryTimesIfNonFail) {
                                    this.cancelRetryTask();
                                }
                                if (times > this.retryLimit) {
                                    this.cancelRetryTask();
                                }
                            }
                            catch (Throwable t) {
                                this.logger.error("0-12", "", "", "Unexpected error occur at failed retry, cause: " + t.getMessage(), t);
                            }
                        }, 500L, this.retryPeriod, TimeUnit.MILLISECONDS);
                    }
                }
            }
        }

        void cancelRetryTask() {
            if (this.retryScheduledFuture != null) {
                this.retryScheduledFuture.cancel(false);
            }
            this.retryExecutor.shutdown();
        }

        void destroy() {
            this.cancelRetryTask();
        }

        @Deprecated
        ScheduledExecutorService getRetryExecutor() {
            return this.retryExecutor;
        }
    }

    private class SaveProperties
    implements Runnable {
        private long version;

        private SaveProperties(long version) {
            this.version = version;
        }

        @Override
        public void run() {
            AbstractMetadataReport.this.doSaveProperties(this.version);
        }
    }
}

