/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.config.ProtocolConfig;
import org.apache.dubbo.config.context.ConfigManager;
import org.apache.dubbo.metadata.MetadataInfo;
import org.apache.dubbo.metadata.MetadataInfoV2;
import org.apache.dubbo.metadata.MetadataServiceV2Detector;
import org.apache.dubbo.metadata.ServiceInfoV2;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class MetadataServiceVersionUtils {
    public static final String V1 = "1.0.0";
    public static final String V2 = "2.0.0";

    public static MetadataInfoV2 toV2(MetadataInfo metadataInfo) {
        if (metadataInfo == null) {
            return MetadataInfoV2.newBuilder().build();
        }
        HashMap<String, ServiceInfoV2> servicesV2 = new HashMap<String, ServiceInfoV2>();
        metadataInfo.getServices().forEach((name, serviceInfo) -> servicesV2.put((String)name, MetadataServiceVersionUtils.toV2(serviceInfo)));
        return MetadataInfoV2.newBuilder().setVersion(MetadataServiceVersionUtils.ifNullSetEmpty(metadataInfo.getRevision())).setApp(MetadataServiceVersionUtils.ifNullSetEmpty(metadataInfo.getApp())).putAllServices(servicesV2).build();
    }

    public static ServiceInfoV2 toV2(MetadataInfo.ServiceInfo serviceInfo) {
        if (serviceInfo == null) {
            return ServiceInfoV2.newBuilder().build();
        }
        return ServiceInfoV2.newBuilder().setVersion(MetadataServiceVersionUtils.ifNullSetEmpty(serviceInfo.getVersion())).setGroup(MetadataServiceVersionUtils.ifNullSetEmpty(serviceInfo.getGroup())).setName(MetadataServiceVersionUtils.ifNullSetEmpty(serviceInfo.getName())).setPort(serviceInfo.getPort()).setPath(MetadataServiceVersionUtils.ifNullSetEmpty(serviceInfo.getPath())).setProtocol(MetadataServiceVersionUtils.ifNullSetEmpty(serviceInfo.getProtocol())).putAllParams(serviceInfo.getAllParams()).build();
    }

    private static String ifNullSetEmpty(String value) {
        return value == null ? "" : value;
    }

    public static MetadataInfo toV1(MetadataInfoV2 metadataInfoV2) {
        Map<String, ServiceInfoV2> servicesV2Map = metadataInfoV2.getServicesMap();
        HashMap<String, MetadataInfo.ServiceInfo> serviceMap = new HashMap<String, MetadataInfo.ServiceInfo>(servicesV2Map.size());
        servicesV2Map.forEach((s, serviceInfoV2) -> serviceMap.put((String)s, MetadataServiceVersionUtils.toV1(serviceInfoV2)));
        return new MetadataInfo(metadataInfoV2.getApp(), metadataInfoV2.getVersion(), serviceMap);
    }

    public static MetadataInfo.ServiceInfo toV1(ServiceInfoV2 serviceInfoV2) {
        MetadataInfo.ServiceInfo serviceInfo = new MetadataInfo.ServiceInfo();
        serviceInfo.setGroup(serviceInfoV2.getGroup());
        serviceInfo.setVersion(serviceInfoV2.getVersion());
        serviceInfo.setName(serviceInfoV2.getName());
        serviceInfo.setPort(serviceInfoV2.getPort());
        serviceInfo.setParams(serviceInfoV2.getParamsMap());
        serviceInfo.setProtocol(serviceInfoV2.getProtocol());
        serviceInfo.setPath(serviceInfoV2.getPath());
        return serviceInfo;
    }

    public static boolean needExportV1(ApplicationModel applicationModel) {
        return !MetadataServiceV2Detector.support() || !MetadataServiceVersionUtils.onlyExportV2(applicationModel);
    }

    public static boolean needExportV2(ApplicationModel applicationModel) {
        return MetadataServiceV2Detector.support() && (MetadataServiceVersionUtils.onlyExportV2(applicationModel) || MetadataServiceVersionUtils.tripleConfigured(applicationModel));
    }

    public static boolean onlyExportV2(ApplicationModel applicationModel) {
        Optional<ApplicationConfig> applicationConfig = MetadataServiceVersionUtils.getApplicationConfig(applicationModel);
        return applicationConfig.filter(config -> Boolean.TRUE.equals(config.getOnlyUseMetadataV2()) && MetadataServiceVersionUtils.tripleConfigured(applicationModel)).isPresent();
    }

    public static boolean tripleConfigured(ApplicationModel applicationModel) {
        Optional<ConfigManager> configManager = Optional.ofNullable(applicationModel.getApplicationConfigManager());
        Optional<ApplicationConfig> appConfig = MetadataServiceVersionUtils.getApplicationConfig(applicationModel);
        if (appConfig.isPresent() && appConfig.get().getMetadataServiceProtocol() != null) {
            return "tri".equals(appConfig.get().getMetadataServiceProtocol());
        }
        if (configManager.isPresent() && CollectionUtils.isNotEmpty((Collection)configManager.get().getProtocols())) {
            Collection protocols = configManager.get().getProtocols();
            for (ProtocolConfig protocolConfig : protocols) {
                if (!"tri".equals(protocolConfig.getName())) continue;
                return true;
            }
        }
        return false;
    }

    private static Optional<ApplicationConfig> getApplicationConfig(ApplicationModel applicationModel) {
        Optional<ConfigManager> configManager = Optional.ofNullable(applicationModel.getApplicationConfigManager());
        if (configManager.isPresent() && configManager.get().getApplication().isPresent()) {
            return configManager.get().getApplication();
        }
        return Optional.empty();
    }
}

