/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.definition.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.ProtocolStringList;
import com.google.protobuf.UnknownFieldSet;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.metadata.definition.TypeDefinitionBuilder;
import org.apache.dubbo.metadata.definition.builder.TypeBuilder;
import org.apache.dubbo.metadata.definition.model.TypeDefinition;

public class ProtobufTypeBuilder
implements TypeBuilder {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final Pattern MAP_PATTERN = Pattern.compile("^java\\.util\\.Map<(\\S+), (\\S+)>$");
    private static final Pattern LIST_PATTERN = Pattern.compile("^java\\.util\\.List<(\\S+)>$");
    private static final List<String> LIST = null;
    private static Type STRING_LIST_TYPE;

    public boolean accept(Type type, Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        return GeneratedMessageV3.class.isAssignableFrom(clazz);
    }

    public TypeDefinition build(Type type, Class<?> clazz, Map<Class<?>, TypeDefinition> typeCache) {
        TypeDefinition typeDefinition = new TypeDefinition(clazz.getName());
        try {
            GeneratedMessageV3.Builder builder = this.getMessageBuilder(clazz);
            typeDefinition = this.buildProtobufTypeDefinition(clazz, builder, typeCache);
        }
        catch (Exception e) {
            this.logger.info("TypeDefinition build failed.", (Throwable)e);
        }
        return typeDefinition;
    }

    private GeneratedMessageV3.Builder getMessageBuilder(Class<?> requestType) throws Exception {
        Method method = requestType.getMethod("newBuilder", new Class[0]);
        return (GeneratedMessageV3.Builder)method.invoke(null, null);
    }

    private TypeDefinition buildProtobufTypeDefinition(Class<?> clazz, GeneratedMessageV3.Builder builder, Map<Class<?>, TypeDefinition> typeCache) {
        Method[] methods;
        TypeDefinition typeDefinition = new TypeDefinition(clazz.getName());
        if (builder == null) {
            return typeDefinition;
        }
        HashMap<String, TypeDefinition> properties = new HashMap<String, TypeDefinition>();
        for (Method method : methods = builder.getClass().getDeclaredMethods()) {
            TypeDefinition td;
            String fieldName;
            Type type;
            String methodName = method.getName();
            if (this.isSimplePropertySettingMethod(method)) {
                properties.put(this.generateSimpleFiledName(methodName), TypeDefinitionBuilder.build((Type)method.getGenericParameterTypes()[0], method.getParameterTypes()[0], typeCache));
                continue;
            }
            if (this.isMapPropertySettingMethod(method)) {
                type = method.getGenericParameterTypes()[0];
                fieldName = this.generateMapFieldName(methodName);
                this.validateMapType(fieldName, type.toString());
                properties.put(fieldName, TypeDefinitionBuilder.build((Type)type, method.getParameterTypes()[0], typeCache));
                continue;
            }
            if (!this.isListPropertyGettingMethod(method)) continue;
            type = method.getGenericReturnType();
            fieldName = this.generateListFieldName(methodName);
            if (ProtocolStringList.class.isAssignableFrom(method.getReturnType())) {
                td = TypeDefinitionBuilder.build((Type)STRING_LIST_TYPE, List.class, typeCache);
            } else {
                if (!LIST_PATTERN.matcher(type.toString()).matches()) continue;
                td = TypeDefinitionBuilder.build((Type)type, method.getReturnType(), typeCache);
            }
            properties.put(fieldName, td);
        }
        typeDefinition.setProperties(properties);
        typeCache.put(clazz, typeDefinition);
        return typeDefinition;
    }

    private void validateMapType(String fieldName, String typeName) {
        Matcher matcher = MAP_PATTERN.matcher(typeName);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Map protobuf property " + fieldName + "of Type " + typeName + " can't be parsed.The type name should match[" + MAP_PATTERN.toString() + "].");
        }
    }

    private String generateSimpleFiledName(String methodName) {
        return this.toCamelCase(methodName.substring(3));
    }

    private String generateMapFieldName(String methodName) {
        return this.toCamelCase(methodName.substring(6));
    }

    private String generateListFieldName(String methodName) {
        return this.toCamelCase(methodName.substring(3, methodName.length() - 4));
    }

    private String toCamelCase(String nameString) {
        char[] chars = nameString.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    private boolean isSimplePropertySettingMethod(Method method) {
        String methodName = method.getName();
        Class<?>[] types = method.getParameterTypes();
        if (!methodName.startsWith("set") || types.length != 1) {
            return false;
        }
        if ("setField".equals(methodName) && types[0].equals(Descriptors.FieldDescriptor.class) || "setUnknownFields".equals(methodName) && types[0].equals(UnknownFieldSet.class) || "setRepeatedField".equals(methodName) && types[0].equals(Descriptors.FieldDescriptor.class)) {
            return false;
        }
        if (methodName.endsWith("Bytes") && types[0].equals(ByteString.class)) {
            return false;
        }
        if (GeneratedMessageV3.Builder.class.isAssignableFrom(types[0])) {
            return false;
        }
        return !methodName.endsWith("Value") || types[0] != Integer.TYPE;
    }

    boolean isListPropertyGettingMethod(Method method) {
        String methodName = method.getName();
        Class<?> type = method.getReturnType();
        if (!methodName.startsWith("get") || !methodName.endsWith("List")) {
            return false;
        }
        if (methodName.endsWith("BuilderList")) {
            return false;
        }
        return List.class.isAssignableFrom(type);
    }

    private boolean isMapPropertySettingMethod(Method methodTemp) {
        String methodName = methodTemp.getName();
        Class<?>[] parameters = methodTemp.getParameterTypes();
        return methodName.startsWith("putAll") && parameters.length == 1 && Map.class.isAssignableFrom(parameters[0]);
    }

    static {
        try {
            STRING_LIST_TYPE = ProtobufTypeBuilder.class.getDeclaredField("LIST").getGenericType();
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
    }
}

