/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.definition;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.metadata.definition.builder.ArrayTypeBuilder;
import org.apache.dubbo.metadata.definition.builder.CollectionTypeBuilder;
import org.apache.dubbo.metadata.definition.builder.DefaultTypeBuilder;
import org.apache.dubbo.metadata.definition.builder.EnumTypeBuilder;
import org.apache.dubbo.metadata.definition.builder.MapTypeBuilder;
import org.apache.dubbo.metadata.definition.builder.TypeBuilder;
import org.apache.dubbo.metadata.definition.model.TypeDefinition;

public class TypeDefinitionBuilder {
    private static final ThreadLocal<ArrayList<TypeBuilder>> builders = new ThreadLocal();
    private Map<Class<?>, TypeDefinition> typeCache = new HashMap();

    public static TypeDefinition build(Type type, Class<?> clazz, Map<Class<?>, TypeDefinition> typeCache) {
        TypeBuilder builder = TypeDefinitionBuilder.getGenericTypeBuilder(type, clazz);
        TypeDefinition td = null;
        td = builder != null ? builder.build(type, clazz, typeCache) : DefaultTypeBuilder.build(clazz, typeCache);
        return td;
    }

    private static TypeBuilder getGenericTypeBuilder(Type type, Class<?> clazz) {
        for (TypeBuilder builder : builders.get()) {
            if (!builder.accept(type, clazz)) continue;
            return builder;
        }
        return null;
    }

    public TypeDefinition build(Type type, Class<?> clazz) {
        return TypeDefinitionBuilder.build(type, clazz, this.typeCache);
    }

    public List<TypeDefinition> getTypeDefinitions() {
        return new ArrayList<TypeDefinition>(this.typeCache.values());
    }

    static {
        builders.set(new ArrayList());
        builders.get().add(new ArrayTypeBuilder());
        builders.get().add(new CollectionTypeBuilder());
        builders.get().add(new MapTypeBuilder());
        builders.get().add(new EnumTypeBuilder());
    }
}

