/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.definition.builder;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Map;
import org.apache.dubbo.metadata.definition.TypeDefinitionBuilder;
import org.apache.dubbo.metadata.definition.builder.DefaultTypeBuilder;
import org.apache.dubbo.metadata.definition.builder.TypeBuilder;
import org.apache.dubbo.metadata.definition.model.TypeDefinition;

public class CollectionTypeBuilder
implements TypeBuilder {
    @Override
    public boolean accept(Type type, Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        return Collection.class.isAssignableFrom(clazz);
    }

    @Override
    public TypeDefinition build(Type type, Class<?> clazz, Map<Class<?>, TypeDefinition> typeCache) {
        if (!(type instanceof ParameterizedType)) {
            return new TypeDefinition(clazz.getName());
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        Type[] actualTypeArgs = parameterizedType.getActualTypeArguments();
        if (actualTypeArgs == null || actualTypeArgs.length != 1) {
            throw new IllegalArgumentException(MessageFormat.format("[ServiceDefinitionBuilder] Collection type [{0}] with unexpected amount of arguments [{1}]." + actualTypeArgs, type, actualTypeArgs));
        }
        Type actualType = actualTypeArgs[0];
        if (actualType instanceof ParameterizedType) {
            Class rawType = (Class)((ParameterizedType)actualType).getRawType();
            TypeDefinitionBuilder.build(actualType, rawType, typeCache);
        } else if (actualType instanceof Class) {
            Class actualClass = (Class)actualType;
            if (actualClass.isArray() || actualClass.isEnum()) {
                TypeDefinitionBuilder.build(null, actualClass, typeCache);
            } else {
                DefaultTypeBuilder.build(actualClass, typeCache);
            }
        }
        TypeDefinition td = new TypeDefinition(type.toString());
        return td;
    }
}

