/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.definition.builder;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Map;
import org.apache.dubbo.metadata.definition.TypeDefinitionBuilder;
import org.apache.dubbo.metadata.definition.builder.TypeBuilder;
import org.apache.dubbo.metadata.definition.model.TypeDefinition;

public class MapTypeBuilder
implements TypeBuilder {
    @Override
    public boolean accept(Type type, Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        return Map.class.isAssignableFrom(clazz);
    }

    @Override
    public TypeDefinition build(Type type, Class<?> clazz, Map<Class<?>, TypeDefinition> typeCache) {
        if (!(type instanceof ParameterizedType)) {
            return new TypeDefinition(clazz.getName());
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        Object[] actualTypeArgs = parameterizedType.getActualTypeArguments();
        if (actualTypeArgs == null || actualTypeArgs.length != 2) {
            throw new IllegalArgumentException(MessageFormat.format("[ServiceDefinitionBuilder] Map type [{0}] with unexpected amount of arguments [{1}]." + Arrays.toString(actualTypeArgs), type, actualTypeArgs));
        }
        for (Object actualType : actualTypeArgs) {
            if (actualType instanceof ParameterizedType) {
                Class rawType = (Class)((ParameterizedType)actualType).getRawType();
                TypeDefinitionBuilder.build((Type)actualType, rawType, typeCache);
                continue;
            }
            if (!(actualType instanceof Class)) continue;
            Class actualClass = (Class)actualType;
            TypeDefinitionBuilder.build(null, actualClass, typeCache);
        }
        return new TypeDefinition(type.toString());
    }
}

