/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.store.consul;

import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.Response;
import com.ecwid.consul.v1.kv.model.GetValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.metadata.report.identifier.BaseMetadataIdentifier;
import org.apache.dubbo.metadata.report.identifier.KeyTypeEnum;
import org.apache.dubbo.metadata.report.identifier.MetadataIdentifier;
import org.apache.dubbo.metadata.report.identifier.ServiceMetadataIdentifier;
import org.apache.dubbo.metadata.report.identifier.SubscriberMetadataIdentifier;
import org.apache.dubbo.metadata.report.support.AbstractMetadataReport;
import org.apache.dubbo.rpc.RpcException;

public class ConsulMetadataReport
extends AbstractMetadataReport {
    private static final Logger logger = LoggerFactory.getLogger(ConsulMetadataReport.class);
    private static final int DEFAULT_PORT = 8500;
    private ConsulClient client;

    public ConsulMetadataReport(URL url) {
        super(url);
        String host = url.getHost();
        int port = url.getPort() != 0 ? url.getPort() : 8500;
        this.client = new ConsulClient(host, port);
    }

    protected void doStoreProviderMetadata(MetadataIdentifier providerMetadataIdentifier, String serviceDefinitions) {
        this.storeMetadata((BaseMetadataIdentifier)providerMetadataIdentifier, serviceDefinitions);
    }

    protected void doStoreConsumerMetadata(MetadataIdentifier consumerMetadataIdentifier, String value) {
        this.storeMetadata((BaseMetadataIdentifier)consumerMetadataIdentifier, value);
    }

    protected void doSaveMetadata(ServiceMetadataIdentifier serviceMetadataIdentifier, URL url) {
        this.storeMetadata((BaseMetadataIdentifier)serviceMetadataIdentifier, URL.encode((String)url.toFullString()));
    }

    protected void doRemoveMetadata(ServiceMetadataIdentifier serviceMetadataIdentifier) {
        this.deleteMetadata((BaseMetadataIdentifier)serviceMetadataIdentifier);
    }

    protected List<String> doGetExportedURLs(ServiceMetadataIdentifier metadataIdentifier) {
        String content = this.getMetadata((BaseMetadataIdentifier)metadataIdentifier);
        if (StringUtils.isEmpty((String)content)) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(Arrays.asList(URL.decode((String)content)));
    }

    protected void doSaveSubscriberData(SubscriberMetadataIdentifier subscriberMetadataIdentifier, String urlListStr) {
        this.storeMetadata((BaseMetadataIdentifier)subscriberMetadataIdentifier, urlListStr);
    }

    protected String doGetSubscribedURLs(SubscriberMetadataIdentifier subscriberMetadataIdentifier) {
        return this.getMetadata((BaseMetadataIdentifier)subscriberMetadataIdentifier);
    }

    private void storeMetadata(BaseMetadataIdentifier identifier, String v) {
        try {
            this.client.setKVValue(identifier.getUniqueKey(KeyTypeEnum.UNIQUE_KEY), v);
        }
        catch (Throwable t) {
            logger.error("Failed to put " + identifier + " to consul " + v + ", cause: " + t.getMessage(), t);
            throw new RpcException("Failed to put " + identifier + " to consul " + v + ", cause: " + t.getMessage(), t);
        }
    }

    private void deleteMetadata(BaseMetadataIdentifier identifier) {
        try {
            this.client.deleteKVValue(identifier.getUniqueKey(KeyTypeEnum.UNIQUE_KEY));
        }
        catch (Throwable t) {
            logger.error("Failed to delete " + identifier + " from consul , cause: " + t.getMessage(), t);
            throw new RpcException("Failed to delete " + identifier + " from consul , cause: " + t.getMessage(), t);
        }
    }

    private String getMetadata(BaseMetadataIdentifier identifier) {
        try {
            Response value = this.client.getKVValue(identifier.getUniqueKey(KeyTypeEnum.UNIQUE_KEY));
            if (value != null && value.getValue() != null) {
                return ((GetValue)value.getValue()).getValue();
            }
            return null;
        }
        catch (Throwable t) {
            logger.error("Failed to get " + identifier + " from consul , cause: " + t.getMessage(), t);
            throw new RpcException("Failed to get " + identifier + " from consul , cause: " + t.getMessage(), t);
        }
    }

    public String getServiceDefinition(MetadataIdentifier metadataIdentifier) {
        return this.getMetadata((BaseMetadataIdentifier)metadataIdentifier);
    }
}

