/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.store.redis;

import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.metadata.identifier.MetadataIdentifier;
import org.apache.dubbo.metadata.support.AbstractMetadataReport;
import org.apache.dubbo.rpc.RpcException;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class RedisMetadataReport
extends AbstractMetadataReport {
    private static final Logger logger = LoggerFactory.getLogger(RedisMetadataReport.class);
    final JedisPool pool;

    public RedisMetadataReport(URL url) {
        super(url);
        this.pool = new JedisPool((GenericObjectPoolConfig)new JedisPoolConfig(), url.getHost(), url.getPort());
    }

    protected void doStoreProviderMetadata(MetadataIdentifier providerMetadataIdentifier, String serviceDefinitions) {
        this.storeMetadata(providerMetadataIdentifier, serviceDefinitions);
    }

    protected void doStoreConsumerMetadata(MetadataIdentifier consumerMetadataIdentifier, String value) {
        this.storeMetadata(consumerMetadataIdentifier, value);
    }

    private void storeMetadata(MetadataIdentifier metadataIdentifier, String v) {
        try (Jedis jedis = this.pool.getResource();){
            jedis.set(metadataIdentifier.getIdentifierKey() + ".metaData", v);
        }
        catch (Throwable e) {
            logger.error("Failed to put " + metadataIdentifier + " to redis " + v + ", cause: " + e.getMessage(), e);
            throw new RpcException("Failed to put " + metadataIdentifier + " to redis " + v + ", cause: " + e.getMessage(), e);
        }
    }
}

