/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.rest;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.dubbo.metadata.definition.model.MethodDefinition;
import org.apache.dubbo.metadata.rest.ArgInfo;
import org.apache.dubbo.metadata.rest.RequestMetadata;
import org.apache.dubbo.metadata.rest.noannotaion.NoAnnotationServiceRestMetadataResolver;
import org.apache.dubbo.metadata.rest.tag.NoAnnotationTag;

public class RestMethodMetadata
implements Serializable {
    private static final long serialVersionUID = 2935252016200830694L;
    private MethodDefinition method;
    private RequestMetadata request;
    private Integer urlIndex;
    private Integer bodyIndex;
    private Integer headerMapIndex;
    private String bodyType;
    private Map<Integer, Collection<String>> indexToName;
    private List<String> formParams;
    private Map<Integer, Boolean> indexToEncoded;
    private List<ArgInfo> argInfos;
    private Method reflectMethod;
    private Class codeStyle;

    public MethodDefinition getMethod() {
        if (this.method == null) {
            this.method = new MethodDefinition();
        }
        return this.method;
    }

    public void setMethod(MethodDefinition method) {
        this.method = method;
    }

    public RequestMetadata getRequest() {
        if (this.request == null) {
            this.request = new RequestMetadata();
        }
        return this.request;
    }

    public void setRequest(RequestMetadata request) {
        this.request = request;
    }

    public Integer getUrlIndex() {
        return this.urlIndex;
    }

    public void setUrlIndex(Integer urlIndex) {
        this.urlIndex = urlIndex;
    }

    public Integer getBodyIndex() {
        return this.bodyIndex;
    }

    public void setBodyIndex(Integer bodyIndex) {
        this.bodyIndex = bodyIndex;
    }

    public Integer getHeaderMapIndex() {
        return this.headerMapIndex;
    }

    public void setHeaderMapIndex(Integer headerMapIndex) {
        this.headerMapIndex = headerMapIndex;
    }

    public String getBodyType() {
        return this.bodyType;
    }

    public void setBodyType(String bodyType) {
        this.bodyType = bodyType;
    }

    public Map<Integer, Collection<String>> getIndexToName() {
        if (this.indexToName == null) {
            this.indexToName = new LinkedHashMap<Integer, Collection<String>>();
        }
        return this.indexToName;
    }

    public void setIndexToName(Map<Integer, Collection<String>> indexToName) {
        this.indexToName = indexToName;
    }

    public void addIndexToName(Integer index, String name) {
        if (index == null) {
            return;
        }
        if (name.startsWith("arg") && name.endsWith(index.toString())) {
            return;
        }
        Map<Integer, Collection<String>> indexToName = this.getIndexToName();
        Collection parameterNames = indexToName.computeIfAbsent(index, i -> new ArrayList(1));
        parameterNames.add(name);
    }

    public boolean hasIndexedName(Integer index, String name) {
        Map<Integer, Collection<String>> indexToName = this.getIndexToName();
        return ((Collection)indexToName.getOrDefault(index, Collections.emptyList())).contains(name);
    }

    public List<String> getFormParams() {
        return this.formParams;
    }

    public void setFormParams(List<String> formParams) {
        this.formParams = formParams;
    }

    public Map<Integer, Boolean> getIndexToEncoded() {
        return this.indexToEncoded;
    }

    public void setIndexToEncoded(Map<Integer, Boolean> indexToEncoded) {
        this.indexToEncoded = indexToEncoded;
    }

    public List<ArgInfo> getArgInfos() {
        if (this.argInfos == null) {
            this.argInfos = new ArrayList<ArgInfo>();
        }
        return this.argInfos;
    }

    public void addArgInfo(ArgInfo argInfo) {
        if (this.currentCodeStyleIsNoAnnotationMode()) {
            argInfo.setParamAnnotationType(NoAnnotationTag.class);
        }
        this.getArgInfos().add(argInfo);
    }

    public Method getReflectMethod() {
        return this.reflectMethod;
    }

    public void setReflectMethod(Method reflectMethod) {
        this.reflectMethod = reflectMethod;
    }

    public Class getCodeStyle() {
        return this.codeStyle;
    }

    public void setCodeStyle(Class codeStyle) {
        this.codeStyle = codeStyle;
    }

    public boolean currentCodeStyleIsNoAnnotationMode() {
        return NoAnnotationServiceRestMetadataResolver.class.equals((Object)this.getCodeStyle());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RestMethodMetadata)) {
            return false;
        }
        RestMethodMetadata that = (RestMethodMetadata)o;
        return Objects.equals(this.getMethod(), that.getMethod()) && Objects.equals(this.getRequest(), that.getRequest()) && Objects.equals(this.getUrlIndex(), that.getUrlIndex()) && Objects.equals(this.getBodyIndex(), that.getBodyIndex()) && Objects.equals(this.getHeaderMapIndex(), that.getHeaderMapIndex()) && Objects.equals(this.getBodyType(), that.getBodyType()) && Objects.equals(this.getFormParams(), that.getFormParams()) && Objects.equals(this.getIndexToEncoded(), that.getIndexToEncoded());
    }

    public int hashCode() {
        return Objects.hash(this.getMethod(), this.getRequest(), this.getUrlIndex(), this.getBodyIndex(), this.getHeaderMapIndex(), this.getBodyType(), this.getFormParams(), this.getIndexToEncoded());
    }

    public String toString() {
        return "RestMethodMetadata{method=" + this.method + ", request=" + this.request + ", urlIndex=" + this.urlIndex + ", bodyIndex=" + this.bodyIndex + ", headerMapIndex=" + this.headerMapIndex + ", bodyType='" + this.bodyType + '\'' + ", indexToName=" + this.indexToName + ", formParams=" + this.formParams + ", indexToEncoded=" + this.indexToEncoded + ", argInfos=" + this.argInfos + ", reflectMethod=" + this.reflectMethod + ", codeStyle=" + this.codeStyle + '}';
    }
}

