/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.rest.jaxrs;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.utils.AnnotationUtils;
import org.apache.dubbo.common.utils.PathUtils;
import org.apache.dubbo.metadata.rest.AbstractServiceRestMetadataResolver;
import org.apache.dubbo.rpc.model.ApplicationModel;

@Activate(order=100)
public class JAXRSServiceRestMetadataResolver
extends AbstractServiceRestMetadataResolver {
    public JAXRSServiceRestMetadataResolver(ApplicationModel applicationModel) {
        super(applicationModel);
    }

    @Override
    protected boolean supports0(Class<?> serviceType) {
        return AnnotationUtils.isAnnotationPresent(serviceType, (String)"javax.ws.rs.Path") || JAXRSServiceRestMetadataResolver.isServiceMethodAnnotationPresent(serviceType, "javax.ws.rs.Path");
    }

    @Override
    protected boolean isRestCapableMethod(Method serviceMethod, Class<?> serviceType, Class<?> serviceInterfaceClass) {
        return AnnotationUtils.isAnnotationPresent((AnnotatedElement)serviceMethod, (String)"javax.ws.rs.HttpMethod");
    }

    @Override
    protected String resolveRequestMethod(Method serviceMethod, Class<?> serviceType, Class<?> serviceInterfaceClass) {
        Annotation httpMethod = AnnotationUtils.findMetaAnnotation((AnnotatedElement)serviceMethod, (String)"javax.ws.rs.HttpMethod");
        return (String)AnnotationUtils.getValue((Annotation)httpMethod);
    }

    @Override
    protected String resolveRequestPath(Method serviceMethod, Class<?> serviceType, Class<?> serviceInterfaceClass) {
        String requestBasePath = this.resolveRequestPathFromType(serviceType, serviceInterfaceClass);
        String requestRelativePath = this.resolveRequestPathFromMethod(serviceMethod);
        return PathUtils.buildPath((String)requestBasePath, (String[])new String[]{requestRelativePath});
    }

    private String resolveRequestPathFromType(Class<?> serviceType, Class<?> serviceInterfaceClass) {
        Annotation path = AnnotationUtils.findAnnotation(serviceType, (String)"javax.ws.rs.Path");
        if (path == null) {
            path = AnnotationUtils.findAnnotation(serviceInterfaceClass, (String)"javax.ws.rs.Path");
        }
        return (String)AnnotationUtils.getValue((Annotation)path);
    }

    private String resolveRequestPathFromMethod(Method serviceMethod) {
        Annotation path = AnnotationUtils.findAnnotation((AnnotatedElement)serviceMethod, (String)"javax.ws.rs.Path");
        return (String)AnnotationUtils.getValue((Annotation)path);
    }

    @Override
    protected void processProduces(Method serviceMethod, Class<?> serviceType, Class<?> serviceInterfaceClass, Set<String> produces) {
        this.addAnnotationValues(serviceMethod, "javax.ws.rs.Produces", produces);
        this.addAnnotationValues(serviceType, "javax.ws.rs.Produces", produces);
        this.addAnnotationValues(serviceInterfaceClass, "javax.ws.rs.Produces", produces);
    }

    @Override
    protected void processConsumes(Method serviceMethod, Class<?> serviceType, Class<?> serviceInterfaceClass, Set<String> consumes) {
        this.addAnnotationValues(serviceMethod, "javax.ws.rs.Consumes", consumes);
        this.addAnnotationValues(serviceType, "javax.ws.rs.Consumes", consumes);
        this.addAnnotationValues(serviceInterfaceClass, "javax.ws.rs.Consumes", consumes);
    }

    private void addAnnotationValues(Method serviceMethod, String annotationAttributeName, Set<String> result) {
        Annotation annotation = AnnotationUtils.findAnnotation((AnnotatedElement)serviceMethod, (String)annotationAttributeName);
        String[] value = (String[])AnnotationUtils.getValue((Annotation)annotation);
        if (value != null) {
            Stream.of(value).forEach(result::add);
        }
    }

    private void addAnnotationValues(Class serviceType, String annotationAttributeName, Set<String> result) {
        Annotation annotation = AnnotationUtils.findAnnotation((AnnotatedElement)serviceType, (String)annotationAttributeName);
        String[] value = (String[])AnnotationUtils.getValue((Annotation)annotation);
        if (value != null) {
            Stream.of(value).forEach(result::add);
        }
    }
}

