/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.collector;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.dubbo.common.metrics.collector.DefaultMetricsCollector;
import org.apache.dubbo.common.metrics.collector.MetricsCollector;
import org.apache.dubbo.common.metrics.event.MetricsEvent;
import org.apache.dubbo.common.metrics.event.RTEvent;
import org.apache.dubbo.common.metrics.event.RequestEvent;
import org.apache.dubbo.common.metrics.listener.MetricsListener;
import org.apache.dubbo.common.metrics.model.MethodMetric;
import org.apache.dubbo.common.metrics.model.MetricsCategory;
import org.apache.dubbo.common.metrics.model.MetricsKey;
import org.apache.dubbo.common.metrics.model.sample.GaugeMetricSample;
import org.apache.dubbo.common.metrics.model.sample.MetricSample;
import org.apache.dubbo.common.utils.ConcurrentHashMapUtils;
import org.apache.dubbo.config.MetricsConfig;
import org.apache.dubbo.config.context.ConfigManager;
import org.apache.dubbo.config.nested.AggregationConfig;
import org.apache.dubbo.metrics.aggregate.TimeWindowCounter;
import org.apache.dubbo.metrics.aggregate.TimeWindowQuantile;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class AggregateMetricsCollector
implements MetricsCollector,
MetricsListener {
    private int bucketNum;
    private int timeWindowSeconds;
    private final ConcurrentMap<MethodMetric, TimeWindowCounter> totalRequests = new ConcurrentHashMap<MethodMetric, TimeWindowCounter>();
    private final ConcurrentMap<MethodMetric, TimeWindowCounter> succeedRequests = new ConcurrentHashMap<MethodMetric, TimeWindowCounter>();
    private final ConcurrentMap<MethodMetric, TimeWindowCounter> unknownFailedRequests = new ConcurrentHashMap<MethodMetric, TimeWindowCounter>();
    private final ConcurrentMap<MethodMetric, TimeWindowCounter> businessFailedRequests = new ConcurrentHashMap<MethodMetric, TimeWindowCounter>();
    private final ConcurrentMap<MethodMetric, TimeWindowCounter> timeoutRequests = new ConcurrentHashMap<MethodMetric, TimeWindowCounter>();
    private final ConcurrentMap<MethodMetric, TimeWindowCounter> limitRequests = new ConcurrentHashMap<MethodMetric, TimeWindowCounter>();
    private final ConcurrentMap<MethodMetric, TimeWindowCounter> totalFailedRequests = new ConcurrentHashMap<MethodMetric, TimeWindowCounter>();
    private final ConcurrentMap<MethodMetric, TimeWindowCounter> qps = new ConcurrentHashMap<MethodMetric, TimeWindowCounter>();
    private final ConcurrentMap<MethodMetric, TimeWindowQuantile> rt = new ConcurrentHashMap<MethodMetric, TimeWindowQuantile>();
    private final ApplicationModel applicationModel;
    private static final Integer DEFAULT_COMPRESSION = 100;
    private static final Integer DEFAULT_BUCKET_NUM = 10;
    private static final Integer DEFAULT_TIME_WINDOW_SECONDS = 120;

    public AggregateMetricsCollector(ApplicationModel applicationModel) {
        this.applicationModel = applicationModel;
        ConfigManager configManager = applicationModel.getApplicationConfigManager();
        MetricsConfig config = configManager.getMetrics().orElse(null);
        if (config != null && config.getAggregation() != null && Boolean.TRUE.equals(config.getAggregation().getEnabled())) {
            this.registerListener();
            AggregationConfig aggregation = config.getAggregation();
            this.bucketNum = aggregation.getBucketNum() == null ? DEFAULT_BUCKET_NUM : aggregation.getBucketNum();
            this.timeWindowSeconds = aggregation.getTimeWindowSeconds() == null ? DEFAULT_TIME_WINDOW_SECONDS : aggregation.getTimeWindowSeconds();
        }
    }

    private void registerListener() {
        ((DefaultMetricsCollector)this.applicationModel.getBeanFactory().getBean(DefaultMetricsCollector.class)).addListener((MetricsListener)this);
    }

    public void onEvent(MetricsEvent event) {
        if (event instanceof RTEvent) {
            this.onRTEvent((RTEvent)event);
        } else if (event instanceof RequestEvent) {
            this.onRequestEvent((RequestEvent)event);
        }
    }

    private void onRTEvent(RTEvent event) {
        MethodMetric metric = (MethodMetric)event.getSource();
        Long responseTime = event.getRt();
        TimeWindowQuantile quantile = (TimeWindowQuantile)ConcurrentHashMapUtils.computeIfAbsent(this.rt, (Object)metric, k -> new TimeWindowQuantile(DEFAULT_COMPRESSION.intValue(), this.bucketNum, this.timeWindowSeconds));
        quantile.add(responseTime.longValue());
    }

    private void onRequestEvent(RequestEvent event) {
        MethodMetric metric = (MethodMetric)event.getSource();
        RequestEvent.Type type = event.getType();
        TimeWindowCounter counter = null;
        switch (type) {
            case TOTAL: {
                counter = (TimeWindowCounter)ConcurrentHashMapUtils.computeIfAbsent(this.totalRequests, (Object)metric, k -> new TimeWindowCounter(this.bucketNum, this.timeWindowSeconds));
                TimeWindowCounter qpsCounter = (TimeWindowCounter)ConcurrentHashMapUtils.computeIfAbsent(this.qps, (Object)metric, k -> new TimeWindowCounter(this.bucketNum, this.timeWindowSeconds));
                qpsCounter.increment();
                break;
            }
            case SUCCEED: {
                counter = (TimeWindowCounter)ConcurrentHashMapUtils.computeIfAbsent(this.succeedRequests, (Object)metric, k -> new TimeWindowCounter(this.bucketNum, this.timeWindowSeconds));
                break;
            }
            case UNKNOWN_FAILED: {
                counter = (TimeWindowCounter)ConcurrentHashMapUtils.computeIfAbsent(this.unknownFailedRequests, (Object)metric, k -> new TimeWindowCounter(this.bucketNum, this.timeWindowSeconds));
                break;
            }
            case BUSINESS_FAILED: {
                counter = (TimeWindowCounter)ConcurrentHashMapUtils.computeIfAbsent(this.businessFailedRequests, (Object)metric, k -> new TimeWindowCounter(this.bucketNum, this.timeWindowSeconds));
                break;
            }
            case REQUEST_TIMEOUT: {
                counter = (TimeWindowCounter)ConcurrentHashMapUtils.computeIfAbsent(this.timeoutRequests, (Object)metric, k -> new TimeWindowCounter(this.bucketNum, this.timeWindowSeconds));
                break;
            }
            case REQUEST_LIMIT: {
                counter = (TimeWindowCounter)ConcurrentHashMapUtils.computeIfAbsent(this.limitRequests, (Object)metric, k -> new TimeWindowCounter(this.bucketNum, this.timeWindowSeconds));
                break;
            }
            case TOTAL_FAILED: {
                counter = (TimeWindowCounter)ConcurrentHashMapUtils.computeIfAbsent(this.totalFailedRequests, (Object)metric, k -> new TimeWindowCounter(this.bucketNum, this.timeWindowSeconds));
                break;
            }
        }
        if (counter != null) {
            counter.increment();
        }
    }

    public List<MetricSample> collect() {
        ArrayList<MetricSample> list = new ArrayList<MetricSample>();
        this.collectRequests(list);
        this.collectQPS(list);
        this.collectRT(list);
        return list;
    }

    private void collectRequests(List<MetricSample> list) {
        this.totalRequests.forEach((k, v) -> list.add((MetricSample)new GaugeMetricSample(MetricsKey.PROVIDER_METRIC_REQUESTS_TOTAL_AGG, k.getTags(), MetricsCategory.REQUESTS, v::get)));
        this.succeedRequests.forEach((k, v) -> list.add((MetricSample)new GaugeMetricSample(MetricsKey.PROVIDER_METRIC_REQUESTS_SUCCEED_AGG, k.getTags(), MetricsCategory.REQUESTS, v::get)));
        this.unknownFailedRequests.forEach((k, v) -> list.add((MetricSample)new GaugeMetricSample(MetricsKey.PROVIDER_METRIC_REQUESTS_FAILED_AGG, k.getTags(), MetricsCategory.REQUESTS, v::get)));
        this.businessFailedRequests.forEach((k, v) -> list.add((MetricSample)new GaugeMetricSample(MetricsKey.PROVIDER_METRIC_REQUESTS_BUSINESS_FAILED_AGG, k.getTags(), MetricsCategory.REQUESTS, v::get)));
        this.timeoutRequests.forEach((k, v) -> list.add((MetricSample)new GaugeMetricSample(MetricsKey.PROVIDER_METRIC_REQUESTS_TIMEOUT_AGG, k.getTags(), MetricsCategory.REQUESTS, v::get)));
        this.limitRequests.forEach((k, v) -> list.add((MetricSample)new GaugeMetricSample(MetricsKey.PROVIDER_METRIC_REQUESTS_LIMIT_AGG, k.getTags(), MetricsCategory.REQUESTS, v::get)));
        this.totalFailedRequests.forEach((k, v) -> list.add((MetricSample)new GaugeMetricSample(MetricsKey.PROVIDER_METRIC_REQUESTS_TOTAL_FAILED_AGG, k.getTags(), MetricsCategory.REQUESTS, v::get)));
    }

    private void collectQPS(List<MetricSample> list) {
        this.qps.forEach((k, v) -> list.add((MetricSample)new GaugeMetricSample(MetricsKey.PROVIDER_METRIC_QPS, k.getTags(), MetricsCategory.QPS, () -> v.get() / (double)v.bucketLivedSeconds())));
    }

    private void collectRT(List<MetricSample> list) {
        this.rt.forEach((k, v) -> {
            list.add((MetricSample)new GaugeMetricSample(MetricsKey.PROVIDER_METRIC_RT_P99, k.getTags(), MetricsCategory.RT, () -> v.quantile(0.99)));
            list.add((MetricSample)new GaugeMetricSample(MetricsKey.PROVIDER_METRIC_RT_P95, k.getTags(), MetricsCategory.RT, () -> v.quantile(0.95)));
        });
    }
}

