/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.data;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.metrics.model.MetricsCategory;
import org.apache.dubbo.metrics.model.MetricsSupport;
import org.apache.dubbo.metrics.model.key.MetricsKey;
import org.apache.dubbo.metrics.model.sample.GaugeMetricSample;
import org.apache.dubbo.metrics.report.MetricsExport;

public class ApplicationStatComposite
implements MetricsExport {
    private final Map<MetricsKey, Map<String, AtomicLong>> applicationNumStats = new ConcurrentHashMap<MetricsKey, Map<String, AtomicLong>>();

    public void init(List<MetricsKey> appKeys) {
        if (CollectionUtils.isEmpty(appKeys)) {
            return;
        }
        appKeys.forEach(appKey -> {
            Map cfr_ignored_0 = this.applicationNumStats.put((MetricsKey)((Object)appKey), new ConcurrentHashMap());
        });
    }

    public void incrementSize(MetricsKey metricsKey, String applicationName, int size) {
        if (!this.applicationNumStats.containsKey((Object)metricsKey)) {
            return;
        }
        this.applicationNumStats.get((Object)metricsKey).computeIfAbsent(applicationName, k -> new AtomicLong(0L)).getAndAdd(size);
    }

    public void setApplicationKey(MetricsKey metricsKey, String applicationName, int num) {
        if (!this.applicationNumStats.containsKey((Object)metricsKey)) {
            return;
        }
        this.applicationNumStats.get((Object)metricsKey).computeIfAbsent(applicationName, k -> new AtomicLong(0L)).set(num);
    }

    @Override
    public List<GaugeMetricSample> export(MetricsCategory category) {
        ArrayList<GaugeMetricSample> list = new ArrayList<GaugeMetricSample>();
        for (MetricsKey type : this.applicationNumStats.keySet()) {
            Map<String, AtomicLong> stringAtomicLongMap = this.applicationNumStats.get((Object)type);
            for (String applicationName : stringAtomicLongMap.keySet()) {
                list.add(this.convertToSample(applicationName, type, category, stringAtomicLongMap.get(applicationName)));
            }
        }
        return list;
    }

    private GaugeMetricSample convertToSample(String applicationName, MetricsKey type, MetricsCategory category, AtomicLong targetNumber) {
        return new GaugeMetricSample<AtomicLong>(type, MetricsSupport.applicationTags(applicationName), category, targetNumber, AtomicLong::get);
    }

    public Map<MetricsKey, Map<String, AtomicLong>> getApplicationNumStats() {
        return this.applicationNumStats;
    }
}

