/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.data;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.metrics.model.MetricsCategory;
import org.apache.dubbo.metrics.model.ServiceKeyMetric;
import org.apache.dubbo.metrics.model.key.MetricsKey;
import org.apache.dubbo.metrics.model.sample.GaugeMetricSample;
import org.apache.dubbo.metrics.report.MetricsExport;

public class ServiceStatComposite
implements MetricsExport {
    private final Map<MetricsKey, Map<ServiceKeyMetric, AtomicLong>> serviceNumStats = new ConcurrentHashMap<MetricsKey, Map<ServiceKeyMetric, AtomicLong>>();

    public void init(List<MetricsKey> serviceKeys) {
        if (CollectionUtils.isEmpty(serviceKeys)) {
            return;
        }
        serviceKeys.forEach(appKey -> {
            Map cfr_ignored_0 = this.serviceNumStats.put((MetricsKey)((Object)appKey), new ConcurrentHashMap());
        });
    }

    public void incrementServiceKey(MetricsKey metricsKey, String applicationName, String serviceKey, int size) {
        if (!this.serviceNumStats.containsKey((Object)metricsKey)) {
            return;
        }
        this.serviceNumStats.get((Object)metricsKey).computeIfAbsent(new ServiceKeyMetric(applicationName, serviceKey), k -> new AtomicLong(0L)).getAndAdd(size);
    }

    public void setServiceKey(MetricsKey type, String applicationName, String serviceKey, int num) {
        if (!this.serviceNumStats.containsKey((Object)type)) {
            return;
        }
        this.serviceNumStats.get((Object)type).computeIfAbsent(new ServiceKeyMetric(applicationName, serviceKey), k -> new AtomicLong(0L)).set(num);
    }

    @Override
    public List<GaugeMetricSample> export(MetricsCategory category) {
        ArrayList<GaugeMetricSample> list = new ArrayList<GaugeMetricSample>();
        for (MetricsKey type : this.serviceNumStats.keySet()) {
            Map<ServiceKeyMetric, AtomicLong> stringAtomicLongMap = this.serviceNumStats.get((Object)type);
            for (ServiceKeyMetric serviceKeyMetric : stringAtomicLongMap.keySet()) {
                list.add(new GaugeMetricSample<Map>(type, serviceKeyMetric.getTags(), category, stringAtomicLongMap, value -> ((AtomicLong)value.get(serviceKeyMetric)).get()));
            }
        }
        return list;
    }
}

