/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.model.key;

import java.util.Map;
import org.apache.dubbo.metrics.model.MetricsSupport;
import org.apache.dubbo.metrics.model.key.MetricsKey;
import org.apache.dubbo.metrics.model.key.MetricsLevel;
import org.apache.dubbo.metrics.model.key.MetricsPlaceType;

public class MetricsKeyWrapper {
    private final MetricsKey metricsKey;
    private final MetricsPlaceType placeType;

    public MetricsKeyWrapper(String type, MetricsKey metricsKey) {
        this(metricsKey, MetricsPlaceType.of(type, MetricsLevel.APP));
    }

    public MetricsKeyWrapper(MetricsKey metricsKey, MetricsPlaceType placeType) {
        this.metricsKey = metricsKey;
        this.placeType = placeType;
    }

    public MetricsPlaceType getPlaceType() {
        return this.placeType;
    }

    public String getType() {
        return this.getPlaceType().getType();
    }

    public MetricsKey getMetricsKey() {
        return this.metricsKey;
    }

    public boolean isKey(MetricsKey metricsKey, String registryOpType) {
        return metricsKey == this.getMetricsKey() && registryOpType.equals(this.getType());
    }

    public boolean isServiceLevel() {
        return this.getPlaceType().getMetricsLevel().equals((Object)MetricsLevel.SERVICE);
    }

    public String targetKey() {
        try {
            return String.format(this.metricsKey.getName(), this.getType());
        }
        catch (Exception ignore) {
            return this.metricsKey.getName();
        }
    }

    public String targetDesc() {
        try {
            return String.format(this.metricsKey.getDescription(), this.getType());
        }
        catch (Exception ignore) {
            return this.metricsKey.getDescription();
        }
    }

    public Map<String, String> tagName(String key) {
        return this.isServiceLevel() ? MetricsSupport.serviceTags(key) : MetricsSupport.applicationTags(key);
    }
}

