/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.model;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.metrics.model.Metric;
import org.apache.dubbo.metrics.model.sample.MetricSample;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.support.RpcUtils;

public class MethodMetric
implements Metric {
    private String applicationName;
    private String side;
    private String interfaceName;
    private String methodName;
    private String group;
    private String version;
    private MetricSample.Type sampleType;

    public MethodMetric() {
    }

    public MethodMetric(String applicationName, Invocation invocation) {
        this.applicationName = applicationName;
        this.sampleType = (MetricSample.Type)((Object)invocation.get((Object)"metric_filter_invocation_counter"));
        this.init(invocation);
    }

    public MetricSample.Type getSampleType() {
        return this.sampleType;
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public void setInterfaceName(String interfaceName) {
        this.interfaceName = interfaceName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public Map<String, String> getTags() {
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("ip", NetUtils.getLocalHost());
        tags.put("hostname", NetUtils.getLocalHostName());
        tags.put("application.name", this.applicationName);
        tags.put("interface", this.interfaceName);
        tags.put("method", this.methodName);
        tags.put("group", this.group);
        tags.put("version", this.version);
        return tags;
    }

    private void init(Invocation invocation) {
        String interfaceAndVersion;
        String serviceUniqueName = invocation.getTargetServiceUniqueName();
        String methodName = invocation.getMethodName();
        if (invocation instanceof RpcInvocation && RpcUtils.isGenericCall((String)((RpcInvocation)invocation).getParameterTypesDesc(), (String)methodName) && invocation.getArguments() != null && invocation.getArguments().length == 3) {
            methodName = ((String)invocation.getArguments()[0]).trim();
        }
        String group = null;
        String[] arr = serviceUniqueName.split("/");
        if (arr.length == 2) {
            group = arr[0];
            interfaceAndVersion = arr[1];
        } else {
            interfaceAndVersion = arr[0];
        }
        String[] ivArr = interfaceAndVersion.split(":");
        String interfaceName = ivArr[0];
        String version = ivArr.length == 2 ? ivArr[1] : null;
        Optional<Invoker> invoker = Optional.ofNullable(invocation.getInvoker());
        this.side = invoker.isPresent() ? invoker.get().getUrl().getSide() : "provider";
        this.interfaceName = interfaceName;
        this.methodName = methodName;
        this.group = group;
        this.version = version;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getSide() {
        return this.side;
    }

    public void setSide(String side) {
        this.side = side;
    }

    public String toString() {
        return "MethodMetric{applicationName='" + this.applicationName + '\'' + ", side='" + this.side + '\'' + ", interfaceName='" + this.interfaceName + '\'' + ", methodName='" + this.methodName + '\'' + ", group='" + this.group + '\'' + ", version='" + this.version + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodMetric that = (MethodMetric)o;
        return Objects.equals(this.applicationName, that.applicationName) && Objects.equals(this.side, that.side) && Objects.equals(this.interfaceName, that.interfaceName) && Objects.equals(this.methodName, that.methodName) && Objects.equals(this.group, that.group) && Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        return Objects.hash(this.applicationName, this.side, this.interfaceName, this.methodName, this.group, this.version);
    }
}

