/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.model;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.dubbo.common.Version;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.metrics.collector.MethodMetricsCollector;
import org.apache.dubbo.metrics.collector.ServiceMetricsCollector;
import org.apache.dubbo.metrics.event.MetricsEvent;
import org.apache.dubbo.metrics.event.TimeCounterEvent;
import org.apache.dubbo.metrics.exception.MetricsNeverHappenException;
import org.apache.dubbo.metrics.model.key.MetricsKey;
import org.apache.dubbo.metrics.model.key.MetricsKeyWrapper;
import org.apache.dubbo.metrics.model.key.MetricsPlaceValue;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.RpcException;

public class MetricsSupport {
    private static final String version = Version.getVersion();
    private static final String commitId = Version.getLastCommitId();

    public static Map<String, String> applicationTags(String applicationName) {
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("ip", NetUtils.getLocalHost());
        tags.put("hostname", NetUtils.getLocalHostName());
        tags.put("application.name", applicationName);
        tags.put("application.version", version);
        tags.put(MetricsKey.METADATA_GIT_COMMITID_METRIC.getName(), commitId);
        return tags;
    }

    public static Map<String, String> serviceTags(String appAndServiceName) {
        String[] keys = appAndServiceName.split("_");
        if (keys.length != 2) {
            throw new MetricsNeverHappenException("Error service name: " + appAndServiceName);
        }
        Map<String, String> tags = MetricsSupport.applicationTags(keys[0]);
        tags.put("interface", keys[1]);
        return tags;
    }

    public static Map<String, String> methodTags(String names) {
        String[] keys = names.split("_");
        if (keys.length != 3) {
            throw new MetricsNeverHappenException("Error names: " + names);
        }
        Map<String, String> tags = MetricsSupport.applicationTags(keys[0]);
        tags.put("interface", keys[1]);
        tags.put("method", keys[2]);
        return tags;
    }

    public static MetricsKey getMetricsKey(RpcException e) {
        MetricsKey targetKey = MetricsKey.METRIC_REQUESTS_FAILED;
        if (e.isTimeout()) {
            targetKey = MetricsKey.METRIC_REQUESTS_TIMEOUT;
        }
        if (e.isLimitExceed()) {
            targetKey = MetricsKey.METRIC_REQUESTS_LIMIT;
        }
        if (e.isBiz()) {
            targetKey = MetricsKey.METRIC_REQUEST_BUSINESS_FAILED;
        }
        if (e.isSerialization()) {
            targetKey = MetricsKey.METRIC_REQUESTS_CODEC_FAILED;
        }
        if (e.isNetwork()) {
            targetKey = MetricsKey.METRIC_REQUESTS_NETWORK_FAILED;
        }
        return targetKey;
    }

    public static MetricsKey getAggMetricsKey(RpcException e) {
        MetricsKey targetKey = MetricsKey.METRIC_REQUESTS_FAILED_AGG;
        if (e.isTimeout()) {
            targetKey = MetricsKey.METRIC_REQUESTS_TIMEOUT_AGG;
        }
        if (e.isLimitExceed()) {
            targetKey = MetricsKey.METRIC_REQUESTS_LIMIT_AGG;
        }
        if (e.isBiz()) {
            targetKey = MetricsKey.METRIC_REQUEST_BUSINESS_FAILED_AGG;
        }
        if (e.isSerialization()) {
            targetKey = MetricsKey.METRIC_REQUESTS_CODEC_FAILED_AGG;
        }
        if (e.isNetwork()) {
            targetKey = MetricsKey.METRIC_REQUESTS_NETWORK_FAILED_AGG;
        }
        return targetKey;
    }

    public static String getSide(Invocation invocation) {
        Optional<Invoker> invoker = Optional.ofNullable(invocation.getInvoker());
        return invoker.isPresent() ? invoker.get().getUrl().getSide() : "provider";
    }

    public static String getInterfaceName(Invocation invocation) {
        String serviceUniqueName = invocation.getTargetServiceUniqueName();
        String[] arr = serviceUniqueName.split("/");
        String interfaceAndVersion = arr.length == 2 ? arr[1] : arr[0];
        String[] ivArr = interfaceAndVersion.split(":");
        return ivArr[0];
    }

    public static void increment(MetricsKey metricsKey, MetricsPlaceValue placeType, ServiceMetricsCollector<TimeCounterEvent> collector, MetricsEvent event) {
        collector.increment(event.appName(), (String)event.getAttachmentValue("serviceKey"), new MetricsKeyWrapper(metricsKey, placeType), 1);
    }

    public static void dec(MetricsKey metricsKey, MetricsPlaceValue placeType, ServiceMetricsCollector<TimeCounterEvent> collector, MetricsEvent event) {
        collector.increment(event.appName(), (String)event.getAttachmentValue("serviceKey"), new MetricsKeyWrapper(metricsKey, placeType), -1);
    }

    public static void incrAndAddRt(MetricsKey metricsKey, MetricsPlaceValue placeType, ServiceMetricsCollector<TimeCounterEvent> collector, TimeCounterEvent event) {
        collector.increment(event.appName(), (String)event.getAttachmentValue("serviceKey"), new MetricsKeyWrapper(metricsKey, placeType), 1);
        collector.addRt(event.appName(), (String)event.getAttachmentValue("serviceKey"), placeType.getType(), event.getTimePair().calc());
    }

    public static void increment(MetricsKey metricsKey, MetricsPlaceValue placeType, MethodMetricsCollector<TimeCounterEvent> collector, MetricsEvent event) {
        collector.increment(event.appName(), (Invocation)event.getAttachmentValue("metric_filter_invocation"), new MetricsKeyWrapper(metricsKey, placeType), 1);
    }

    public static void dec(MetricsKey metricsKey, MetricsPlaceValue placeType, MethodMetricsCollector<TimeCounterEvent> collector, MetricsEvent event) {
        collector.increment(event.appName(), (Invocation)event.getAttachmentValue("metric_filter_invocation"), new MetricsKeyWrapper(metricsKey, placeType), -1);
    }

    public static void incrAndAddRt(MetricsKey metricsKey, MetricsPlaceValue placeType, MethodMetricsCollector<TimeCounterEvent> collector, TimeCounterEvent event) {
        collector.increment(event.appName(), (Invocation)event.getAttachmentValue("metric_filter_invocation"), new MetricsKeyWrapper(metricsKey, placeType), 1);
        collector.addRt(event.appName(), (Invocation)event.getAttachmentValue("metric_filter_invocation"), placeType.getType(), event.getTimePair().calc());
    }
}

