/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAccumulator;
import java.util.stream.Collectors;
import org.apache.dubbo.common.utils.ConcurrentHashMapUtils;
import org.apache.dubbo.metrics.model.MetricsCategory;
import org.apache.dubbo.metrics.model.container.AtomicLongContainer;
import org.apache.dubbo.metrics.model.container.LongAccumulatorContainer;
import org.apache.dubbo.metrics.model.container.LongContainer;
import org.apache.dubbo.metrics.model.key.MetricsKey;
import org.apache.dubbo.metrics.model.key.MetricsKeyWrapper;
import org.apache.dubbo.metrics.model.key.MetricsPlaceValue;
import org.apache.dubbo.metrics.model.sample.GaugeMetricSample;
import org.apache.dubbo.metrics.model.sample.MetricSample;
import org.apache.dubbo.metrics.report.AbstractMetricsExport;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class RtStatComposite
extends AbstractMetricsExport {
    private final List<LongContainer<? extends Number>> rtStats = new ArrayList<LongContainer<? extends Number>>();

    public RtStatComposite(ApplicationModel applicationModel) {
        super(applicationModel);
    }

    public void init(MetricsPlaceValue ... placeValues) {
        if (placeValues == null) {
            return;
        }
        Arrays.stream(placeValues).forEach(metricsPlaceType -> this.rtStats.addAll(this.initStats((MetricsPlaceValue)metricsPlaceType)));
    }

    private List<LongContainer<? extends Number>> initStats(MetricsPlaceValue placeValue) {
        ArrayList<LongContainer<? extends Number>> singleRtStats = new ArrayList<LongContainer<? extends Number>>();
        singleRtStats.add(new AtomicLongContainer(new MetricsKeyWrapper(MetricsKey.METRIC_RT_LAST, placeValue)));
        singleRtStats.add(new LongAccumulatorContainer(new MetricsKeyWrapper(MetricsKey.METRIC_RT_MIN, placeValue), new LongAccumulator(Long::min, Long.MAX_VALUE)));
        singleRtStats.add(new LongAccumulatorContainer(new MetricsKeyWrapper(MetricsKey.METRIC_RT_MAX, placeValue), new LongAccumulator(Long::max, Long.MIN_VALUE)));
        singleRtStats.add(new AtomicLongContainer(new MetricsKeyWrapper(MetricsKey.METRIC_RT_SUM, placeValue), (responseTime, longAccumulator) -> longAccumulator.addAndGet((long)responseTime)));
        AtomicLongContainer avgContainer = new AtomicLongContainer(new MetricsKeyWrapper(MetricsKey.METRIC_RT_AVG, placeValue), (k, v) -> v.incrementAndGet());
        avgContainer.setValueSupplier(applicationName -> {
            LongContainer totalContainer = this.rtStats.stream().filter(longContainer -> longContainer.isKeyWrapper(MetricsKey.METRIC_RT_SUM, placeValue.getType())).findFirst().get();
            AtomicLong totalRtTimes = (AtomicLong)avgContainer.get(applicationName);
            AtomicLong totalRtSum = (AtomicLong)totalContainer.get(applicationName);
            return totalRtSum.get() / totalRtTimes.get();
        });
        singleRtStats.add(avgContainer);
        return singleRtStats;
    }

    public void calcApplicationRt(String registryOpType, Long responseTime) {
        for (LongContainer container : this.rtStats.stream().filter(longContainer -> longContainer.specifyType(registryOpType)).collect(Collectors.toList())) {
            Number current = (Number)ConcurrentHashMapUtils.computeIfAbsent((ConcurrentMap)container, (Object)this.getAppName(), container.getInitFunc());
            container.getConsumerFunc().accept(responseTime, current);
        }
    }

    public void calcServiceKeyRt(String serviceKey, String registryOpType, Long responseTime) {
        for (LongContainer container : this.rtStats.stream().filter(longContainer -> longContainer.specifyType(registryOpType)).collect(Collectors.toList())) {
            Number current = (Number)ConcurrentHashMapUtils.computeIfAbsent((ConcurrentMap)container, (Object)serviceKey, container.getInitFunc());
            container.getConsumerFunc().accept(responseTime, current);
        }
    }

    public void calcMethodKeyRt(Invocation invocation, String registryOpType, Long responseTime) {
        for (LongContainer container : this.rtStats.stream().filter(longContainer -> longContainer.specifyType(registryOpType)).collect(Collectors.toList())) {
            Number current = (Number)ConcurrentHashMapUtils.computeIfAbsent((ConcurrentMap)container, (Object)(invocation.getServiceName() + "_" + invocation.getMethodName()), container.getInitFunc());
            container.getConsumerFunc().accept(responseTime, current);
        }
    }

    @Override
    public List<MetricSample> export(MetricsCategory category) {
        ArrayList<MetricSample> list = new ArrayList<MetricSample>();
        for (LongContainer<? extends Number> rtContainer : this.rtStats) {
            MetricsKeyWrapper metricsKeyWrapper = rtContainer.getMetricsKeyWrapper();
            for (Map.Entry entry : rtContainer.entrySet()) {
                list.add(new GaugeMetricSample<String>(metricsKeyWrapper.targetKey(), metricsKeyWrapper.targetDesc(), metricsKeyWrapper.tagName(this.getApplicationModel(), (String)entry.getKey()), category, ((String)entry.getKey()).intern(), value -> rtContainer.getValueSupplier().apply(value.intern()).longValue()));
            }
        }
        return list;
    }

    public List<LongContainer<? extends Number>> getRtStats() {
        return this.rtStats;
    }
}

