/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.collector;

import java.util.List;
import org.apache.dubbo.metrics.collector.ApplicationMetricsCollector;
import org.apache.dubbo.metrics.collector.MethodMetricsCollector;
import org.apache.dubbo.metrics.collector.ServiceMetricsCollector;
import org.apache.dubbo.metrics.data.BaseStatComposite;
import org.apache.dubbo.metrics.event.MetricsEventMulticaster;
import org.apache.dubbo.metrics.event.TimeCounterEvent;
import org.apache.dubbo.metrics.listener.AbstractMetricsListener;
import org.apache.dubbo.metrics.model.MethodMetric;
import org.apache.dubbo.metrics.model.MetricsCategory;
import org.apache.dubbo.metrics.model.key.MetricsKey;
import org.apache.dubbo.metrics.model.key.MetricsKeyWrapper;
import org.apache.dubbo.metrics.model.sample.MetricSample;
import org.apache.dubbo.rpc.Invocation;

public abstract class CombMetricsCollector<E extends TimeCounterEvent>
extends AbstractMetricsListener<E>
implements ApplicationMetricsCollector<E>,
ServiceMetricsCollector<E>,
MethodMetricsCollector<E> {
    protected final BaseStatComposite stats;
    private MetricsEventMulticaster eventMulticaster;

    public CombMetricsCollector(BaseStatComposite stats) {
        this.stats = stats;
    }

    protected void setEventMulticaster(MetricsEventMulticaster eventMulticaster) {
        this.eventMulticaster = eventMulticaster;
    }

    @Override
    public void setNum(MetricsKeyWrapper metricsKey, String serviceKey, int num) {
        this.stats.setServiceKey(metricsKey, serviceKey, num);
    }

    @Override
    public void increment(MetricsKey metricsKey) {
        this.stats.incrementApp(metricsKey, 1);
    }

    @Override
    public void increment(String serviceKey, MetricsKeyWrapper metricsKeyWrapper, int size) {
        this.stats.incrementServiceKey(metricsKeyWrapper, serviceKey, size);
    }

    @Override
    public void addApplicationRt(String registryOpType, Long responseTime) {
        this.stats.calcApplicationRt(registryOpType, responseTime);
    }

    @Override
    public void addServiceRt(String serviceKey, String registryOpType, Long responseTime) {
        this.stats.calcServiceKeyRt(serviceKey, registryOpType, responseTime);
    }

    @Override
    public void addServiceRt(Invocation invocation, String registryOpType, Long responseTime) {
        this.stats.calcServiceKeyRt(invocation, registryOpType, responseTime);
    }

    @Override
    public void addMethodRt(Invocation invocation, String registryOpType, Long responseTime) {
        this.stats.calcMethodKeyRt(invocation, registryOpType, responseTime);
    }

    @Override
    public void increment(MethodMetric methodMetric, MetricsKeyWrapper wrapper, int size) {
        this.stats.incrementMethodKey(wrapper, methodMetric, size);
    }

    protected List<MetricSample> export(MetricsCategory category) {
        return this.stats.export(category);
    }

    public MetricsEventMulticaster getEventMulticaster() {
        return this.eventMulticaster;
    }

    @Override
    public void onEvent(TimeCounterEvent event) {
        this.eventMulticaster.publishEvent(event);
    }

    @Override
    public void onEventFinish(TimeCounterEvent event) {
        this.eventMulticaster.publishFinishEvent(event);
    }

    @Override
    public void onEventError(TimeCounterEvent event) {
        this.eventMulticaster.publishErrorEvent(event);
    }

    protected BaseStatComposite getStats() {
        return this.stats;
    }
}

