/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.aggregate;

import com.tdunning.math.stats.Centroid;
import com.tdunning.math.stats.TDigest;

public abstract class DubboAbstractTDigest
extends TDigest {
    boolean recordAllData = false;

    static double weightedAverage(double x1, double w1, double x2, double w2) {
        if (x1 <= x2) {
            return DubboAbstractTDigest.weightedAverageSorted(x1, w1, x2, w2);
        }
        return DubboAbstractTDigest.weightedAverageSorted(x2, w2, x1, w1);
    }

    private static double weightedAverageSorted(double x1, double w1, double x2, double w2) {
        assert (x1 <= x2);
        double x = (x1 * w1 + x2 * w2) / (w1 + w2);
        return Math.max(x1, Math.min(x, x2));
    }

    abstract void add(double var1, int var3, Centroid var4);

    public TDigest recordAllData() {
        this.recordAllData = true;
        return this;
    }

    public boolean isRecording() {
        return this.recordAllData;
    }

    public void add(double x) {
        this.add(x, 1);
    }

    public void add(TDigest other) {
        for (Centroid centroid : other.centroids()) {
            this.add(centroid.mean(), centroid.count(), centroid);
        }
    }
}

