/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.listener;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dubbo.common.utils.ReflectionUtils;
import org.apache.dubbo.metrics.event.MetricsEvent;
import org.apache.dubbo.metrics.listener.MetricsListener;

public abstract class AbstractMetricsListener<E extends MetricsEvent>
implements MetricsListener<E> {
    private final Map<Integer, Boolean> eventMatchCache = new ConcurrentHashMap<Integer, Boolean>();

    public boolean isSupport(MetricsEvent event) {
        Boolean eventMatch = this.eventMatchCache.get(System.identityHashCode(event.getClass()));
        if (eventMatch == null) {
            eventMatch = ReflectionUtils.match(this.getClass(), AbstractMetricsListener.class, (Object)event);
            this.eventMatchCache.put(System.identityHashCode(event.getClass()), eventMatch);
        }
        return event.isAvailable() && eventMatch != false;
    }

    public abstract void onEvent(E var1);
}

