/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.config.collector;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.config.context.ConfigManager;
import org.apache.dubbo.metrics.collector.CombMetricsCollector;
import org.apache.dubbo.metrics.config.event.ConfigCenterEvent;
import org.apache.dubbo.metrics.config.event.ConfigCenterSubDispatcher;
import org.apache.dubbo.metrics.event.MetricsEventMulticaster;
import org.apache.dubbo.metrics.model.ConfigCenterMetric;
import org.apache.dubbo.metrics.model.MetricsCategory;
import org.apache.dubbo.metrics.model.key.MetricsKey;
import org.apache.dubbo.metrics.model.sample.GaugeMetricSample;
import org.apache.dubbo.metrics.model.sample.MetricSample;
import org.apache.dubbo.rpc.model.ApplicationModel;

@Activate
public class ConfigCenterMetricsCollector
extends CombMetricsCollector<ConfigCenterEvent> {
    private Boolean collectEnabled = null;
    private final ApplicationModel applicationModel;
    private final Map<ConfigCenterMetric, AtomicLong> updatedMetrics = new ConcurrentHashMap<ConfigCenterMetric, AtomicLong>();

    public ConfigCenterMetricsCollector(ApplicationModel applicationModel) {
        super(null);
        this.applicationModel = applicationModel;
        super.setEventMulticaster((MetricsEventMulticaster)new ConfigCenterSubDispatcher(this));
    }

    public void setCollectEnabled(Boolean collectEnabled) {
        if (collectEnabled != null) {
            this.collectEnabled = collectEnabled;
        }
    }

    public boolean isCollectEnabled() {
        if (this.collectEnabled == null) {
            ConfigManager configManager = this.applicationModel.getApplicationConfigManager();
            configManager.getMetrics().ifPresent(metricsConfig -> this.setCollectEnabled(metricsConfig.getEnableMetadata()));
        }
        return Optional.ofNullable(this.collectEnabled).orElse(true);
    }

    public void increase(String key, String group, String protocol, String changeTypeName, int size) {
        if (!this.isCollectEnabled()) {
            return;
        }
        ConfigCenterMetric metric = new ConfigCenterMetric(this.applicationModel.getApplicationName(), key, group, protocol, changeTypeName);
        this.updatedMetrics.computeIfAbsent(metric, k -> new AtomicLong(0L)).addAndGet(size);
    }

    public List<MetricSample> collect() {
        ArrayList<MetricSample> list = new ArrayList<MetricSample>();
        if (!this.isCollectEnabled()) {
            return list;
        }
        this.updatedMetrics.forEach((k, v) -> list.add((MetricSample)new GaugeMetricSample(MetricsKey.CONFIGCENTER_METRIC_TOTAL, k.getTags(), MetricsCategory.CONFIGCENTER, v, AtomicLong::get)));
        return list;
    }
}

