/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.collector;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.apache.dubbo.metrics.collector.MetricsCollector;
import org.apache.dubbo.metrics.collector.stat.MetricsStatComposite;
import org.apache.dubbo.metrics.collector.stat.MetricsStatHandler;
import org.apache.dubbo.metrics.event.EmptyEvent;
import org.apache.dubbo.metrics.event.MetricsEvent;
import org.apache.dubbo.metrics.event.SimpleMetricsEventMulticaster;
import org.apache.dubbo.metrics.listener.MetricsListener;
import org.apache.dubbo.metrics.model.MetricsCategory;
import org.apache.dubbo.metrics.model.MetricsKey;
import org.apache.dubbo.metrics.model.sample.GaugeMetricSample;
import org.apache.dubbo.metrics.model.sample.MetricSample;
import org.apache.dubbo.rpc.Invocation;

public class DefaultMetricsCollector
implements MetricsCollector {
    private AtomicBoolean collectEnabled = new AtomicBoolean(false);
    private final MetricsStatComposite stats = new MetricsStatComposite(this);
    private final SimpleMetricsEventMulticaster eventMulticaster = SimpleMetricsEventMulticaster.getInstance();

    public void setCollectEnabled(Boolean collectEnabled) {
        this.collectEnabled.compareAndSet(this.isCollectEnabled(), collectEnabled);
    }

    public Boolean isCollectEnabled() {
        return this.collectEnabled.get();
    }

    public void increaseTotalRequests(String applicationName, Invocation invocation) {
        this.increaseAndPublishEvent(applicationName, MetricsEvent.Type.TOTAL, invocation);
    }

    public void increaseSucceedRequests(String applicationName, Invocation invocation) {
        this.increaseAndPublishEvent(applicationName, MetricsEvent.Type.SUCCEED, invocation);
    }

    public void increaseUnknownFailedRequests(String applicationName, Invocation invocation) {
        this.increaseAndPublishEvent(applicationName, MetricsEvent.Type.UNKNOWN_FAILED, invocation);
    }

    public void businessFailedRequests(String applicationName, Invocation invocation) {
        this.increaseAndPublishEvent(applicationName, MetricsEvent.Type.BUSINESS_FAILED, invocation);
    }

    public void timeoutRequests(String applicationName, Invocation invocation) {
        this.increaseAndPublishEvent(applicationName, MetricsEvent.Type.REQUEST_TIMEOUT, invocation);
    }

    public void limitRequests(String applicationName, Invocation invocation) {
        this.increaseAndPublishEvent(applicationName, MetricsEvent.Type.REQUEST_LIMIT, invocation);
    }

    public void increaseProcessingRequests(String applicationName, Invocation invocation) {
        this.increaseAndPublishEvent(applicationName, MetricsEvent.Type.PROCESSING, invocation);
    }

    public void decreaseProcessingRequests(String applicationName, Invocation invocation) {
        this.decreaseAndPublishEvent(applicationName, MetricsEvent.Type.PROCESSING, invocation);
    }

    public void totalFailedRequests(String applicationName, Invocation invocation) {
        this.increaseAndPublishEvent(applicationName, MetricsEvent.Type.TOTAL_FAILED, invocation);
    }

    private void increaseAndPublishEvent(String applicationName, MetricsEvent.Type total, Invocation invocation) {
        this.eventMulticaster.publishEvent(this.doExecute(total, statHandler -> statHandler.increase(applicationName, invocation)));
    }

    private void decreaseAndPublishEvent(String applicationName, MetricsEvent.Type type, Invocation invocation) {
        this.eventMulticaster.publishEvent(this.doExecute(type, statHandler -> statHandler.decrease(applicationName, invocation)));
    }

    public void addRT(String applicationName, Invocation invocation, Long responseTime) {
        this.eventMulticaster.publishEvent(this.stats.addRtAndRetrieveEvent(applicationName, invocation, responseTime));
    }

    public void addApplicationInfo(String applicationName, String version) {
        this.doExecute(MetricsEvent.Type.APPLICATION_INFO, statHandler -> statHandler.addApplication(applicationName, version));
    }

    public List<MetricSample> collect() {
        ArrayList<MetricSample> list = new ArrayList<MetricSample>();
        this.collectApplication(list);
        this.collectRequests(list);
        this.collectRT(list);
        return list;
    }

    private void collectApplication(List<MetricSample> list) {
        this.doCollect(MetricsEvent.Type.APPLICATION_INFO, MetricsStatHandler::get).filter(e -> !e.isEmpty()).ifPresent(map -> map.forEach((k, v) -> list.add((MetricSample)new GaugeMetricSample(MetricsKey.APPLICATION_METRIC_INFO, k.getTags(), MetricsCategory.APPLICATION, v::get))));
    }

    private void collectRequests(List<MetricSample> list) {
        this.doCollect(MetricsEvent.Type.TOTAL, MetricsStatHandler::get).filter(e -> !e.isEmpty()).ifPresent(map -> map.forEach((k, v) -> list.add((MetricSample)new GaugeMetricSample(MetricsKey.PROVIDER_METRIC_REQUESTS, k.getTags(), MetricsCategory.REQUESTS, v::get))));
        this.doCollect(MetricsEvent.Type.SUCCEED, MetricsStatHandler::get).filter(e -> !e.isEmpty()).ifPresent(map -> map.forEach((k, v) -> list.add((MetricSample)new GaugeMetricSample(MetricsKey.PROVIDER_METRIC_REQUESTS_SUCCEED, k.getTags(), MetricsCategory.REQUESTS, v::get))));
        this.doCollect(MetricsEvent.Type.UNKNOWN_FAILED, MetricsStatHandler::get).filter(e -> !e.isEmpty()).ifPresent(map -> map.forEach((k, v) -> list.add((MetricSample)new GaugeMetricSample(MetricsKey.PROVIDER_METRIC_REQUESTS_FAILED, k.getTags(), MetricsCategory.REQUESTS, v::get))));
        this.doCollect(MetricsEvent.Type.PROCESSING, MetricsStatHandler::get).filter(e -> !e.isEmpty()).ifPresent(map -> map.forEach((k, v) -> list.add((MetricSample)new GaugeMetricSample(MetricsKey.PROVIDER_METRIC_REQUESTS_PROCESSING, k.getTags(), MetricsCategory.REQUESTS, v::get))));
        this.doCollect(MetricsEvent.Type.BUSINESS_FAILED, MetricsStatHandler::get).filter(e -> !e.isEmpty()).ifPresent(map -> map.forEach((k, v) -> list.add((MetricSample)new GaugeMetricSample(MetricsKey.PROVIDER_METRIC_REQUEST_BUSINESS_FAILED, k.getTags(), MetricsCategory.REQUESTS, v::get))));
        this.doCollect(MetricsEvent.Type.REQUEST_TIMEOUT, MetricsStatHandler::get).filter(e -> !e.isEmpty()).ifPresent(map -> map.forEach((k, v) -> list.add((MetricSample)new GaugeMetricSample(MetricsKey.PROVIDER_METRIC_REQUESTS_TIMEOUT, k.getTags(), MetricsCategory.REQUESTS, v::get))));
        this.doCollect(MetricsEvent.Type.REQUEST_LIMIT, MetricsStatHandler::get).filter(e -> !e.isEmpty()).ifPresent(map -> map.forEach((k, v) -> list.add((MetricSample)new GaugeMetricSample(MetricsKey.PROVIDER_METRIC_REQUESTS_LIMIT, k.getTags(), MetricsCategory.REQUESTS, v::get))));
        this.doCollect(MetricsEvent.Type.TOTAL_FAILED, MetricsStatHandler::get).filter(e -> !e.isEmpty()).ifPresent(map -> map.forEach((k, v) -> list.add((MetricSample)new GaugeMetricSample(MetricsKey.PROVIDER_METRIC_REQUESTS_TOTAL_FAILED, k.getTags(), MetricsCategory.REQUESTS, v::get))));
    }

    private void collectRT(List<MetricSample> list) {
        this.stats.getLastRT().forEach((k, v) -> list.add((MetricSample)new GaugeMetricSample(MetricsKey.PROVIDER_METRIC_RT_LAST, k.getTags(), MetricsCategory.RT, v::get)));
        this.stats.getMinRT().forEach((k, v) -> list.add((MetricSample)new GaugeMetricSample(MetricsKey.PROVIDER_METRIC_RT_MIN, k.getTags(), MetricsCategory.RT, v::get)));
        this.stats.getMaxRT().forEach((k, v) -> list.add((MetricSample)new GaugeMetricSample(MetricsKey.PROVIDER_METRIC_RT_MAX, k.getTags(), MetricsCategory.RT, v::get)));
        this.stats.getTotalRT().forEach((k, v) -> {
            list.add((MetricSample)new GaugeMetricSample(MetricsKey.PROVIDER_METRIC_RT_SUM, k.getTags(), MetricsCategory.RT, v::get));
            AtomicLong avg = this.stats.getAvgRT().get(k);
            AtomicLong count = this.stats.getRtCount().get(k);
            avg.set(v.get() / count.get());
            list.add((MetricSample)new GaugeMetricSample(MetricsKey.PROVIDER_METRIC_RT_AVG, k.getTags(), MetricsCategory.RT, avg::get));
        });
    }

    private <T> Optional<T> doCollect(MetricsEvent.Type metricsEventType, Function<MetricsStatHandler, T> statExecutor) {
        if (this.isCollectEnabled().booleanValue()) {
            MetricsStatHandler handler = this.stats.getHandler(metricsEventType);
            T result = statExecutor.apply(handler);
            return Optional.ofNullable(result);
        }
        return Optional.empty();
    }

    private MetricsEvent doExecute(MetricsEvent.Type metricsEventType, Function<MetricsStatHandler, MetricsEvent> statExecutor) {
        if (this.isCollectEnabled().booleanValue()) {
            MetricsStatHandler handler = this.stats.getHandler(metricsEventType);
            return statExecutor.apply(handler);
        }
        return EmptyEvent.instance();
    }

    public void addListener(MetricsListener listener) {
        this.eventMulticaster.addListener(listener);
    }
}

