/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.collector.stat;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import org.apache.dubbo.metrics.collector.stat.MetricsStatHandler;
import org.apache.dubbo.metrics.event.EmptyEvent;
import org.apache.dubbo.metrics.event.MetricsEvent;
import org.apache.dubbo.metrics.model.ApplicationMetric;
import org.apache.dubbo.metrics.model.MethodMetric;
import org.apache.dubbo.rpc.Invocation;

public class DefaultMetricsStatHandler
implements MetricsStatHandler {
    private final Map<MethodMetric, AtomicLong> counts = new ConcurrentHashMap<MethodMetric, AtomicLong>();
    private final Map<ApplicationMetric, AtomicLong> applicationMetrics = new ConcurrentHashMap<ApplicationMetric, AtomicLong>();

    public MetricsEvent increase(String applicationName, Invocation invocation) {
        return this.doIncrExecute(applicationName, invocation);
    }

    public MetricsEvent decrease(String applicationName, Invocation invocation) {
        return this.doDecrExecute(applicationName, invocation);
    }

    public MetricsEvent addApplication(String applicationName, String version) {
        ApplicationMetric applicationMetric = new ApplicationMetric(applicationName, version);
        AtomicLong count = this.applicationMetrics.computeIfAbsent(applicationMetric, k -> new AtomicLong(0L));
        count.incrementAndGet();
        return EmptyEvent.instance();
    }

    protected MetricsEvent doExecute(String applicationName, Invocation invocation, BiConsumer<MethodMetric, Map<MethodMetric, AtomicLong>> execute) {
        MethodMetric metric = new MethodMetric(applicationName, invocation);
        execute.accept(metric, this.counts);
        return this.retrieveMetricsEvent(metric);
    }

    protected MetricsEvent doIncrExecute(String applicationName, Invocation invocation) {
        return this.doExecute(applicationName, invocation, (metric, counts) -> {
            AtomicLong count = counts.computeIfAbsent(metric, k -> new AtomicLong(0L));
            count.incrementAndGet();
        });
    }

    protected MetricsEvent doDecrExecute(String applicationName, Invocation invocation) {
        return this.doExecute(applicationName, invocation, (metric, counts) -> {
            AtomicLong count = counts.computeIfAbsent(metric, k -> new AtomicLong(0L));
            count.decrementAndGet();
        });
    }

    public Map<MethodMetric, AtomicLong> get() {
        return this.counts;
    }

    public MetricsEvent retrieveMetricsEvent(MethodMetric metric) {
        return EmptyEvent.instance();
    }

    public Map<ApplicationMetric, AtomicLong> getApplicationMetric() {
        return this.applicationMetrics;
    }
}

