/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.filter;

import java.util.function.Supplier;
import org.apache.dubbo.metrics.collector.DefaultMetricsCollector;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;

public class MetricsCollectExecutor {
    public static void beforeExecute(String applicationName, DefaultMetricsCollector collector, Invocation invocation) {
        collector.increaseTotalRequests(applicationName, invocation);
        collector.increaseProcessingRequests(applicationName, invocation);
        invocation.put((Object)"metric_filter_start_time", (Object)System.currentTimeMillis());
    }

    public static void postExecute(String applicationName, DefaultMetricsCollector collector, Invocation invocation, Result result) {
        if (result.hasException()) {
            MetricsCollectExecutor.throwExecute(applicationName, collector, invocation, result.getException());
            return;
        }
        collector.increaseSucceedRequests(applicationName, invocation);
        MetricsCollectExecutor.endExecute(applicationName, collector, invocation);
    }

    public static void throwExecute(String applicationName, DefaultMetricsCollector collector, Invocation invocation, Throwable throwable) {
        if (throwable instanceof RpcException) {
            RpcException rpcException = (RpcException)throwable;
            switch (rpcException.getCode()) {
                case 2: {
                    collector.timeoutRequests(applicationName, invocation);
                    break;
                }
                case 7: {
                    collector.limitRequests(applicationName, invocation);
                    break;
                }
                case 3: {
                    collector.businessFailedRequests(applicationName, invocation);
                    break;
                }
                default: {
                    collector.increaseUnknownFailedRequests(applicationName, invocation);
                }
            }
        }
        collector.totalFailedRequests(applicationName, invocation);
        MetricsCollectExecutor.endExecute(applicationName, collector, invocation, () -> throwable instanceof RpcException && ((RpcException)throwable).isBiz());
    }

    private static void endExecute(String applicationName, DefaultMetricsCollector collector, Invocation invocation) {
        MetricsCollectExecutor.endExecute(applicationName, collector, invocation, () -> true);
    }

    private static void endExecute(String applicationName, DefaultMetricsCollector collector, Invocation invocation, Supplier<Boolean> rtStat) {
        if (rtStat.get().booleanValue()) {
            Long endTime = System.currentTimeMillis();
            Long beginTime = (Long)invocation.get((Object)"metric_filter_start_time");
            Long rt = endTime - beginTime;
            collector.addRT(applicationName, invocation, rt);
        }
        collector.decreaseProcessingRequests(applicationName, invocation);
    }
}

