/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.filter;

import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.metrics.collector.DefaultMetricsCollector;
import org.apache.dubbo.metrics.filter.MetricsCollectExecutor;
import org.apache.dubbo.rpc.BaseFilter;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.ScopeModelAware;

@Activate(group={"provider"}, order=-1)
public class MetricsFilter
implements Filter,
BaseFilter.Listener,
ScopeModelAware {
    private DefaultMetricsCollector collector = null;
    private ApplicationModel applicationModel;

    public void setApplicationModel(ApplicationModel applicationModel) {
        this.applicationModel = applicationModel;
        this.collector = (DefaultMetricsCollector)applicationModel.getBeanFactory().getBean(DefaultMetricsCollector.class);
    }

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        if (this.collector == null || !this.collector.isCollectEnabled().booleanValue()) {
            return invoker.invoke(invocation);
        }
        MetricsCollectExecutor.beforeExecute(this.applicationModel.getApplicationName(), this.collector, invocation);
        return invoker.invoke(invocation);
    }

    public void onResponse(Result result, Invoker<?> invoker, Invocation invocation) {
        if (this.collector == null || !this.collector.isCollectEnabled().booleanValue()) {
            return;
        }
        MetricsCollectExecutor.postExecute(this.applicationModel.getApplicationName(), this.collector, invocation, result);
    }

    public void onError(Throwable t, Invoker<?> invoker, Invocation invocation) {
        if (this.collector == null || !this.collector.isCollectEnabled().booleanValue()) {
            return;
        }
        MetricsCollectExecutor.throwExecute(this.applicationModel.getApplicationName(), this.collector, invocation, t);
    }
}

