/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.report;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.binder.jvm.ClassLoaderMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmGcMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmMemoryMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmThreadMetrics;
import io.micrometer.core.instrument.binder.system.ProcessorMetrics;
import io.micrometer.core.instrument.binder.system.UptimeMetrics;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.lang.ShutdownHookCallbacks;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.metrics.DubboMetrics;
import org.apache.dubbo.metrics.collector.AggregateMetricsCollector;
import org.apache.dubbo.metrics.collector.DefaultMetricsCollector;
import org.apache.dubbo.metrics.collector.MetricsCollector;
import org.apache.dubbo.metrics.model.sample.GaugeMetricSample;
import org.apache.dubbo.metrics.model.sample.MetricSample;
import org.apache.dubbo.metrics.report.MetricsReporter;
import org.apache.dubbo.rpc.model.ApplicationModel;

public abstract class AbstractMetricsReporter
implements MetricsReporter {
    private final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(AbstractMetricsReporter.class);
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final AtomicBoolean addGlobalRegistry = new AtomicBoolean(false);
    protected final URL url;
    protected final List<MetricsCollector> collectors = new ArrayList<MetricsCollector>();
    protected final CompositeMeterRegistry compositeRegistry = new CompositeMeterRegistry();
    private final ApplicationModel applicationModel;

    protected AbstractMetricsReporter(URL url, ApplicationModel applicationModel) {
        this.url = url;
        this.applicationModel = applicationModel;
    }

    public void init() {
        if (this.initialized.compareAndSet(false, true)) {
            this.addJvmMetrics();
            this.initCollectors();
            this.doInit();
            this.registerDubboShutdownHook();
        }
    }

    protected void addMeterRegistry(MeterRegistry registry) {
        this.compositeRegistry.add(registry);
    }

    private void addDubboMeterRegistry() {
        MeterRegistry globalRegistry = DubboMetrics.globalRegistry;
        if (globalRegistry != null && !this.addGlobalRegistry.get()) {
            this.compositeRegistry.add(globalRegistry);
            this.addGlobalRegistry.set(true);
        }
    }

    protected ApplicationModel getApplicationModel() {
        return this.applicationModel;
    }

    private void addJvmMetrics() {
        boolean enableJvmMetrics = this.url.getParameter("enable.jvm.metrics", false);
        if (enableJvmMetrics) {
            Tags extraTags = Tags.of((String)"application.name", (String)Optional.ofNullable(this.applicationModel.getApplicationName()).orElse(""));
            new ClassLoaderMetrics((Iterable)extraTags).bindTo((MeterRegistry)this.compositeRegistry);
            new JvmMemoryMetrics((Iterable)extraTags).bindTo((MeterRegistry)this.compositeRegistry);
            JvmGcMetrics jvmGcMetrics = new JvmGcMetrics((Iterable)extraTags);
            jvmGcMetrics.bindTo((MeterRegistry)this.compositeRegistry);
            Runtime.getRuntime().addShutdownHook(new Thread(() -> ((JvmGcMetrics)jvmGcMetrics).close()));
            new ProcessorMetrics((Iterable)extraTags).bindTo((MeterRegistry)this.compositeRegistry);
            new JvmThreadMetrics((Iterable)extraTags).bindTo((MeterRegistry)this.compositeRegistry);
            new UptimeMetrics((Iterable)extraTags).bindTo((MeterRegistry)this.compositeRegistry);
        }
    }

    private void initCollectors() {
        this.applicationModel.getBeanFactory().getOrRegisterBean(AggregateMetricsCollector.class);
        this.collectors.add((MetricsCollector)this.applicationModel.getBeanFactory().getBean(DefaultMetricsCollector.class));
        this.collectors.add((MetricsCollector)this.applicationModel.getBeanFactory().getBean(AggregateMetricsCollector.class));
    }

    public void refreshData() {
        this.addDubboMeterRegistry();
        this.collectors.forEach(collector -> {
            List samples = collector.collect();
            for (MetricSample sample : samples) {
                try {
                    switch (sample.getType()) {
                        case GAUGE: {
                            GaugeMetricSample gaugeSample = (GaugeMetricSample)sample;
                            ArrayList tags = new ArrayList();
                            gaugeSample.getTags().forEach((k, v) -> {
                                if (v == null) {
                                    v = "";
                                }
                                tags.add(Tag.of((String)k, (String)v));
                            });
                            Gauge.builder((String)gaugeSample.getName(), (Supplier)gaugeSample.getSupplier()).description(gaugeSample.getDescription()).tags(tags).register((MeterRegistry)this.compositeRegistry);
                            break;
                        }
                        case COUNTER: 
                        case TIMER: 
                        case LONG_TASK_TIMER: 
                        case DISTRIBUTION_SUMMARY: {
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    this.logger.error("0-13", "", "", "error occurred when synchronize metrics collector.", (Throwable)e);
                }
            }
        });
    }

    private void registerDubboShutdownHook() {
        ((ShutdownHookCallbacks)this.applicationModel.getBeanFactory().getBean(ShutdownHookCallbacks.class)).addCallback(this::destroy);
    }

    public void destroy() {
        this.doDestroy();
    }

    protected abstract void doInit();

    protected abstract void doDestroy();
}

