/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.metrics.collector.AggregateMetricsCollector;
import org.apache.dubbo.metrics.collector.DefaultMetricsCollector;
import org.apache.dubbo.metrics.collector.MetricsCollector;
import org.apache.dubbo.metrics.model.MetricsCategory;
import org.apache.dubbo.metrics.model.sample.GaugeMetricSample;
import org.apache.dubbo.metrics.model.sample.MetricSample;
import org.apache.dubbo.metrics.service.MetricsEntity;
import org.apache.dubbo.metrics.service.MetricsService;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class DefaultMetricsService
implements MetricsService {
    protected final List<MetricsCollector> collectors = new ArrayList<MetricsCollector>();
    private final ApplicationModel applicationModel;

    public DefaultMetricsService(ApplicationModel applicationModel) {
        this.applicationModel = applicationModel;
        this.collectors.add((MetricsCollector)applicationModel.getBeanFactory().getBean(DefaultMetricsCollector.class));
        this.collectors.add((MetricsCollector)applicationModel.getBeanFactory().getBean(AggregateMetricsCollector.class));
    }

    public Map<MetricsCategory, List<MetricsEntity>> getMetricsByCategories(List<MetricsCategory> categories) {
        return this.getMetricsByCategories(null, categories);
    }

    public Map<MetricsCategory, List<MetricsEntity>> getMetricsByCategories(String serviceUniqueName, List<MetricsCategory> categories) {
        return this.getMetricsByCategories(serviceUniqueName, null, null, categories);
    }

    public Map<MetricsCategory, List<MetricsEntity>> getMetricsByCategories(String serviceUniqueName, String methodName, Class<?>[] parameterTypes, List<MetricsCategory> categories) {
        HashMap<MetricsCategory, List<MetricsEntity>> result = new HashMap<MetricsCategory, List<MetricsEntity>>();
        for (MetricsCollector collector : this.collectors) {
            List samples = collector.collect();
            for (MetricSample sample : samples) {
                if (!categories.contains(sample.getCategory())) continue;
                List entities = result.computeIfAbsent(sample.getCategory(), k -> new ArrayList());
                entities.add(this.sampleToEntity(sample));
            }
        }
        return result;
    }

    private MetricsEntity sampleToEntity(MetricSample sample) {
        MetricsEntity entity = new MetricsEntity();
        entity.setName(sample.getName());
        entity.setTags(sample.getTags());
        entity.setCategory(sample.getCategory());
        switch (sample.getType()) {
            case GAUGE: {
                GaugeMetricSample gaugeSample = (GaugeMetricSample)sample;
                entity.setValue(gaugeSample.getSupplier().get());
                break;
            }
        }
        return entity;
    }
}

