/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.register;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.dubbo.config.nested.HistogramConfig;
import org.apache.dubbo.metrics.register.MetricRegister;
import org.apache.dubbo.metrics.sample.HistogramMetricSample;

public class HistogramMetricRegister
implements MetricRegister<HistogramMetricSample, Timer> {
    private final MeterRegistry registry;
    private final HistogramConfig config;

    public HistogramMetricRegister(MeterRegistry registry, HistogramConfig config) {
        this.registry = registry;
        this.config = config;
    }

    @Override
    public Timer register(HistogramMetricSample sample) {
        ArrayList tags = new ArrayList();
        sample.getTags().forEach((k, v) -> {
            if (v == null) {
                v = "";
            }
            tags.add(Tag.of((String)k, (String)v));
        });
        Timer.Builder builder = Timer.builder((String)sample.getName()).description(sample.getDescription()).tags(tags);
        if (Boolean.TRUE.equals(this.config.getEnabledPercentiles())) {
            builder.publishPercentileHistogram(Boolean.valueOf(true));
        }
        if (this.config.getPercentiles() != null) {
            builder.publishPercentiles(this.config.getPercentiles());
        }
        if (this.config.getBucketsMs() != null) {
            builder.serviceLevelObjectives((Duration[])Arrays.stream(this.config.getBucketsMs()).map(Duration::ofMillis).toArray(Duration[]::new));
        }
        if (this.config.getMinExpectedMs() != null) {
            builder.minimumExpectedValue(Duration.ofMillis(this.config.getMinExpectedMs().intValue()));
        }
        if (this.config.getMaxExpectedMs() != null) {
            builder.maximumExpectedValue(Duration.ofMillis(this.config.getMaxExpectedMs().intValue()));
        }
        if (this.config.getDistributionStatisticExpiryMin() != null) {
            builder.distributionStatisticExpiry(Duration.ofMinutes(this.config.getDistributionStatisticExpiryMin().intValue()));
        }
        return builder.register(this.registry);
    }
}

