/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.collector;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.dubbo.common.utils.ConcurrentHashMapUtils;
import org.apache.dubbo.config.MetricsConfig;
import org.apache.dubbo.config.context.ConfigManager;
import org.apache.dubbo.config.nested.AggregationConfig;
import org.apache.dubbo.metrics.aggregate.TimeWindowCounter;
import org.apache.dubbo.metrics.aggregate.TimeWindowQuantile;
import org.apache.dubbo.metrics.collector.DefaultMetricsCollector;
import org.apache.dubbo.metrics.collector.MetricsCollector;
import org.apache.dubbo.metrics.event.MetricsEvent;
import org.apache.dubbo.metrics.event.RequestEvent;
import org.apache.dubbo.metrics.listener.MetricsListener;
import org.apache.dubbo.metrics.model.MethodMetric;
import org.apache.dubbo.metrics.model.MetricsCategory;
import org.apache.dubbo.metrics.model.MetricsSupport;
import org.apache.dubbo.metrics.model.key.MetricsKey;
import org.apache.dubbo.metrics.model.key.MetricsKeyWrapper;
import org.apache.dubbo.metrics.model.key.MetricsLevel;
import org.apache.dubbo.metrics.model.key.MetricsPlaceValue;
import org.apache.dubbo.metrics.model.sample.GaugeMetricSample;
import org.apache.dubbo.metrics.model.sample.MetricSample;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class AggregateMetricsCollector
implements MetricsCollector<RequestEvent> {
    private int bucketNum;
    private int timeWindowSeconds;
    private final Map<MetricsKeyWrapper, ConcurrentHashMap<MethodMetric, TimeWindowCounter>> methodTypeCounter = new ConcurrentHashMap<MetricsKeyWrapper, ConcurrentHashMap<MethodMetric, TimeWindowCounter>>();
    private final ConcurrentMap<MethodMetric, TimeWindowQuantile> rt = new ConcurrentHashMap<MethodMetric, TimeWindowQuantile>();
    private final ConcurrentHashMap<MethodMetric, TimeWindowCounter> qps = new ConcurrentHashMap();
    private final ApplicationModel applicationModel;
    private static final Integer DEFAULT_COMPRESSION = 100;
    private static final Integer DEFAULT_BUCKET_NUM = 10;
    private static final Integer DEFAULT_TIME_WINDOW_SECONDS = 120;
    private Boolean collectEnabled = null;

    public AggregateMetricsCollector(ApplicationModel applicationModel) {
        Optional optional;
        this.applicationModel = applicationModel;
        ConfigManager configManager = applicationModel.getApplicationConfigManager();
        if (this.isCollectEnabled() && (optional = configManager.getMetrics()).isPresent()) {
            this.registerListener();
            AggregationConfig aggregation = ((MetricsConfig)optional.get()).getAggregation();
            this.bucketNum = aggregation.getBucketNum() == null ? DEFAULT_BUCKET_NUM : aggregation.getBucketNum();
            this.timeWindowSeconds = aggregation.getTimeWindowSeconds() == null ? DEFAULT_TIME_WINDOW_SECONDS : aggregation.getTimeWindowSeconds();
        }
    }

    public void setCollectEnabled(Boolean collectEnabled) {
        if (collectEnabled != null) {
            this.collectEnabled = collectEnabled;
        }
    }

    public boolean isCollectEnabled() {
        if (this.collectEnabled == null) {
            ConfigManager configManager = this.applicationModel.getApplicationConfigManager();
            configManager.getMetrics().ifPresent(metricsConfig -> this.setCollectEnabled(metricsConfig.getAggregation().getEnabled()));
        }
        return Optional.ofNullable(this.collectEnabled).orElse(true);
    }

    public boolean isSupport(MetricsEvent event) {
        return event instanceof RequestEvent;
    }

    public void onEvent(RequestEvent event) {
        MethodMetric metric = this.calcWindowCounter(event, MetricsKey.METRIC_REQUESTS);
        TimeWindowCounter qpsCounter = (TimeWindowCounter)ConcurrentHashMapUtils.computeIfAbsent(this.qps, (Object)metric, methodMetric -> new TimeWindowCounter(this.bucketNum, this.timeWindowSeconds));
        qpsCounter.increment();
    }

    public void onEventFinish(RequestEvent event) {
        MetricsKey targetKey = MetricsKey.METRIC_REQUESTS_SUCCEED;
        Object throwableObj = event.getAttachmentValue("metric_filter_throwable");
        if (throwableObj != null) {
            targetKey = MetricsSupport.getAggMetricsKey((Throwable)((Throwable)throwableObj));
        }
        this.calcWindowCounter(event, targetKey);
        this.onRTEvent(event);
    }

    public void onEventError(RequestEvent event) {
        MetricsKey targetKey = MetricsKey.METRIC_REQUESTS_FAILED;
        Object throwableObj = event.getAttachmentValue("metric_filter_throwable");
        if (throwableObj != null) {
            targetKey = MetricsSupport.getAggMetricsKey((Throwable)((Throwable)throwableObj));
        }
        this.calcWindowCounter(event, targetKey);
        this.onRTEvent(event);
    }

    private void onRTEvent(RequestEvent event) {
        MethodMetric metric = new MethodMetric(this.applicationModel, (Invocation)event.getAttachmentValue("metric_filter_invocation"));
        long responseTime = event.getTimePair().calc();
        TimeWindowQuantile quantile = (TimeWindowQuantile)ConcurrentHashMapUtils.computeIfAbsent(this.rt, (Object)metric, k -> new TimeWindowQuantile((double)DEFAULT_COMPRESSION.intValue(), this.bucketNum, this.timeWindowSeconds));
        quantile.add((double)responseTime);
    }

    private MethodMetric calcWindowCounter(RequestEvent event, MetricsKey targetKey) {
        MetricsPlaceValue placeType = MetricsPlaceValue.of((String)((String)event.getAttachmentValue("metric_filter_side")), (MetricsLevel)MetricsLevel.SERVICE);
        MetricsKeyWrapper metricsKeyWrapper = new MetricsKeyWrapper(targetKey, placeType);
        MethodMetric metric = new MethodMetric(this.applicationModel, (Invocation)event.getAttachmentValue("metric_filter_invocation"));
        ConcurrentMap counter = this.methodTypeCounter.computeIfAbsent(metricsKeyWrapper, k -> new ConcurrentHashMap());
        TimeWindowCounter windowCounter = (TimeWindowCounter)ConcurrentHashMapUtils.computeIfAbsent((ConcurrentMap)counter, (Object)metric, methodMetric -> new TimeWindowCounter(this.bucketNum, this.timeWindowSeconds));
        windowCounter.increment();
        return metric;
    }

    public List<MetricSample> collect() {
        ArrayList<MetricSample> list = new ArrayList<MetricSample>();
        this.collectRequests(list);
        this.collectQPS(list);
        this.collectRT(list);
        return list;
    }

    private void collectRequests(List<MetricSample> list) {
        this.collectBySide(list, "provider");
        this.collectBySide(list, "consumer");
    }

    private void collectBySide(List<MetricSample> list, String side) {
        this.collectMethod(list, side, MetricsKey.METRIC_REQUESTS_TOTAL_AGG);
        this.collectMethod(list, side, MetricsKey.METRIC_REQUESTS_SUCCEED_AGG);
        this.collectMethod(list, side, MetricsKey.METRIC_REQUESTS_FAILED_AGG);
        this.collectMethod(list, side, MetricsKey.METRIC_REQUEST_BUSINESS_FAILED_AGG);
        this.collectMethod(list, side, MetricsKey.METRIC_REQUESTS_TIMEOUT_AGG);
        this.collectMethod(list, side, MetricsKey.METRIC_REQUESTS_LIMIT_AGG);
        this.collectMethod(list, side, MetricsKey.METRIC_REQUESTS_TOTAL_FAILED_AGG);
        this.collectMethod(list, side, MetricsKey.METRIC_REQUESTS_NETWORK_FAILED_AGG);
        this.collectMethod(list, side, MetricsKey.METRIC_REQUESTS_CODEC_FAILED_AGG);
        this.collectMethod(list, side, MetricsKey.METRIC_REQUESTS_TOTAL_SERVICE_UNAVAILABLE_FAILED_AGG);
    }

    private void collectMethod(List<MetricSample> list, String side, MetricsKey metricsKey) {
        MetricsKeyWrapper metricsKeyWrapper = new MetricsKeyWrapper(metricsKey, MetricsPlaceValue.of((String)side, (MetricsLevel)MetricsLevel.SERVICE));
        ConcurrentHashMap<MethodMetric, TimeWindowCounter> windowCounter = this.methodTypeCounter.get(metricsKeyWrapper);
        if (windowCounter != null) {
            windowCounter.forEach((k, v) -> list.add((MetricSample)new GaugeMetricSample(metricsKey.getNameByType(k.getSide()), metricsKey.getDescription(), k.getTags(), MetricsCategory.REQUESTS, v, TimeWindowCounter::get)));
        }
    }

    private void collectQPS(List<MetricSample> list) {
        this.qps.forEach((k, v) -> list.add((MetricSample)new GaugeMetricSample(MetricsKey.METRIC_QPS.getNameByType(k.getSide()), MetricsKey.METRIC_QPS.getDescription(), k.getTags(), MetricsCategory.QPS, v, value -> value.get() / (double)value.bucketLivedSeconds())));
    }

    private void collectRT(List<MetricSample> list) {
        this.rt.forEach((k, v) -> {
            list.add((MetricSample)new GaugeMetricSample(MetricsKey.METRIC_RT_P99.getNameByType(k.getSide()), MetricsKey.METRIC_RT_P99.getDescription(), k.getTags(), MetricsCategory.RT, v, value -> value.quantile(0.99)));
            list.add((MetricSample)new GaugeMetricSample(MetricsKey.METRIC_RT_P95.getNameByType(k.getSide()), MetricsKey.METRIC_RT_P95.getDescription(), k.getTags(), MetricsCategory.RT, v, value -> value.quantile(0.95)));
            list.add((MetricSample)new GaugeMetricSample(MetricsKey.METRIC_RT_P90.getNameByType(k.getSide()), MetricsKey.METRIC_RT_P90.getDescription(), k.getTags(), MetricsCategory.RT, v, value -> value.quantile(0.9)));
            list.add((MetricSample)new GaugeMetricSample(MetricsKey.METRIC_RT_P50.getNameByType(k.getSide()), MetricsKey.METRIC_RT_P50.getDescription(), k.getTags(), MetricsCategory.RT, v, value -> value.quantile(0.5)));
        });
    }

    private void registerListener() {
        ((DefaultMetricsCollector)((Object)this.applicationModel.getBeanFactory().getBean(DefaultMetricsCollector.class))).getEventMulticaster().addListener((MetricsListener)this);
    }
}

