/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.collector.sample;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.dubbo.common.constants.CommonConstants;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.store.DataStore;
import org.apache.dubbo.common.threadpool.event.ThreadPoolExhaustedListener;
import org.apache.dubbo.common.threadpool.manager.FrameworkExecutorRepository;
import org.apache.dubbo.common.threadpool.support.AbortPolicyWithReport;
import org.apache.dubbo.common.utils.ConcurrentHashMapUtils;
import org.apache.dubbo.metrics.collector.DefaultMetricsCollector;
import org.apache.dubbo.metrics.collector.sample.MetricThreadPoolExhaustedListener;
import org.apache.dubbo.metrics.collector.sample.MetricsSampler;
import org.apache.dubbo.metrics.collector.sample.ThreadRejectMetricsCountSampler;
import org.apache.dubbo.metrics.model.MetricsCategory;
import org.apache.dubbo.metrics.model.ThreadPoolMetric;
import org.apache.dubbo.metrics.model.key.MetricsKey;
import org.apache.dubbo.metrics.model.sample.GaugeMetricSample;
import org.apache.dubbo.metrics.model.sample.MetricSample;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class ThreadPoolMetricsSampler
implements MetricsSampler {
    private final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(ThreadPoolMetricsSampler.class);
    private final DefaultMetricsCollector collector;
    private FrameworkExecutorRepository frameworkExecutorRepository;
    private DataStore dataStore;
    private final Map<String, ThreadPoolExecutor> sampleThreadPoolExecutor = new ConcurrentHashMap<String, ThreadPoolExecutor>();
    private final ConcurrentHashMap<String, ThreadPoolMetric> threadPoolMetricMap = new ConcurrentHashMap();
    private final AtomicBoolean samplesChanged = new AtomicBoolean(true);

    public ThreadPoolMetricsSampler(DefaultMetricsCollector collector) {
        this.collector = collector;
    }

    public void addExecutors(String name, ExecutorService executorService) {
        Optional.ofNullable(executorService).filter(Objects::nonNull).filter(e -> e instanceof ThreadPoolExecutor).map(e -> (ThreadPoolExecutor)e).ifPresent(threadPoolExecutor -> {
            this.sampleThreadPoolExecutor.put(name, (ThreadPoolExecutor)threadPoolExecutor);
            this.samplesChanged.set(true);
        });
    }

    @Override
    public List<MetricSample> sample() {
        ArrayList<MetricSample> metricSamples = new ArrayList<MetricSample>();
        this.sampleThreadPoolExecutor.forEach((name, executor) -> metricSamples.addAll(this.createMetricsSample((String)name, (ThreadPoolExecutor)executor)));
        return metricSamples;
    }

    private List<MetricSample> createMetricsSample(String name, ThreadPoolExecutor executor) {
        ArrayList<MetricSample> list = new ArrayList<MetricSample>();
        ThreadPoolMetric threadPoolMetric = (ThreadPoolMetric)ConcurrentHashMapUtils.computeIfAbsent(this.threadPoolMetricMap, (Object)name, v -> new ThreadPoolMetric(this.collector.getApplicationName(), name, executor));
        list.add((MetricSample)new GaugeMetricSample(MetricsKey.THREAD_POOL_CORE_SIZE, threadPoolMetric.getTags(), MetricsCategory.THREAD_POOL, (Object)threadPoolMetric, ThreadPoolMetric::getCorePoolSize));
        list.add((MetricSample)new GaugeMetricSample(MetricsKey.THREAD_POOL_LARGEST_SIZE, threadPoolMetric.getTags(), MetricsCategory.THREAD_POOL, (Object)threadPoolMetric, ThreadPoolMetric::getLargestPoolSize));
        list.add((MetricSample)new GaugeMetricSample(MetricsKey.THREAD_POOL_MAX_SIZE, threadPoolMetric.getTags(), MetricsCategory.THREAD_POOL, (Object)threadPoolMetric, ThreadPoolMetric::getMaximumPoolSize));
        list.add((MetricSample)new GaugeMetricSample(MetricsKey.THREAD_POOL_ACTIVE_SIZE, threadPoolMetric.getTags(), MetricsCategory.THREAD_POOL, (Object)threadPoolMetric, ThreadPoolMetric::getActiveCount));
        list.add((MetricSample)new GaugeMetricSample(MetricsKey.THREAD_POOL_THREAD_COUNT, threadPoolMetric.getTags(), MetricsCategory.THREAD_POOL, (Object)threadPoolMetric, ThreadPoolMetric::getPoolSize));
        list.add((MetricSample)new GaugeMetricSample(MetricsKey.THREAD_POOL_QUEUE_SIZE, threadPoolMetric.getTags(), MetricsCategory.THREAD_POOL, (Object)threadPoolMetric, ThreadPoolMetric::getQueueSize));
        return list;
    }

    public void registryDefaultSampleThreadPoolExecutor() {
        ApplicationModel applicationModel = this.collector.getApplicationModel();
        if (applicationModel == null) {
            return;
        }
        try {
            if (this.frameworkExecutorRepository == null) {
                this.frameworkExecutorRepository = (FrameworkExecutorRepository)this.collector.getApplicationModel().getBeanFactory().getBean(FrameworkExecutorRepository.class);
            }
        }
        catch (Exception ex) {
            this.logger.warn("0-13", "", "", "ThreadPoolMetricsSampler! frameworkExecutorRepository non-init");
        }
        if (this.dataStore == null) {
            this.dataStore = (DataStore)this.collector.getApplicationModel().getExtensionLoader(DataStore.class).getDefaultExtension();
        }
        if (this.dataStore != null) {
            ExecutorService executor;
            Map executors = this.dataStore.get(CommonConstants.EXECUTOR_SERVICE_COMPONENT_KEY);
            for (Map.Entry entry2 : executors.entrySet()) {
                executor = (ExecutorService)entry2.getValue();
                if (!(executor instanceof ThreadPoolExecutor)) continue;
                this.addExecutors("DubboServerHandler-" + (String)entry2.getKey(), executor);
            }
            executors = this.dataStore.get("CONSUMER_SHARED_SERVICE_EXECUTOR");
            for (Map.Entry entry2 : executors.entrySet()) {
                executor = (ExecutorService)entry2.getValue();
                if (!(executor instanceof ThreadPoolExecutor)) continue;
                this.addExecutors("DubboClientHandler-" + (String)entry2.getKey(), executor);
            }
            ThreadRejectMetricsCountSampler threadRejectMetricsCountSampler = new ThreadRejectMetricsCountSampler(this.collector);
            this.sampleThreadPoolExecutor.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith("DubboServerHandler")).forEach(entry -> {
                if (((ThreadPoolExecutor)entry.getValue()).getRejectedExecutionHandler() instanceof AbortPolicyWithReport) {
                    MetricThreadPoolExhaustedListener metricThreadPoolExhaustedListener = new MetricThreadPoolExhaustedListener((String)entry.getKey(), threadRejectMetricsCountSampler);
                    ((AbortPolicyWithReport)((ThreadPoolExecutor)entry.getValue()).getRejectedExecutionHandler()).addThreadPoolExhaustedEventListener((ThreadPoolExhaustedListener)metricThreadPoolExhaustedListener);
                }
            });
        }
        if (this.frameworkExecutorRepository != null) {
            this.addExecutors("sharedExecutor", this.frameworkExecutorRepository.getSharedExecutor());
        }
    }

    @Override
    public boolean calSamplesChanged() {
        return this.samplesChanged.compareAndSet(true, false);
    }
}

