/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.collector.sample;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.dubbo.metrics.collector.DefaultMetricsCollector;
import org.apache.dubbo.metrics.collector.sample.MetricsCountSampleConfigurer;
import org.apache.dubbo.metrics.collector.sample.MetricsNameCountSampler;
import org.apache.dubbo.metrics.model.MetricsCategory;
import org.apache.dubbo.metrics.model.ThreadPoolRejectMetric;
import org.apache.dubbo.metrics.model.key.MetricsKey;
import org.apache.dubbo.metrics.model.sample.GaugeMetricSample;
import org.apache.dubbo.metrics.model.sample.MetricSample;

public class ThreadRejectMetricsCountSampler
extends MetricsNameCountSampler<String, String, ThreadPoolRejectMetric> {
    public ThreadRejectMetricsCountSampler(DefaultMetricsCollector collector) {
        super(collector, MetricsCategory.THREAD_POOL, MetricsKey.THREAD_POOL_THREAD_REJECT_COUNT);
    }

    @Override
    protected MetricSample provideMetricsSample(ThreadPoolRejectMetric metric, AtomicLong count, MetricsKey metricsKey, MetricsCategory metricsCategory) {
        return new GaugeMetricSample(metricsKey.getNameByType(metric.getThreadPoolName()), metricsKey.getDescription(), metric.getTags(), metricsCategory, (Object)count, AtomicLong::get);
    }

    @Override
    protected void countConfigure(MetricsCountSampleConfigurer<String, String, ThreadPoolRejectMetric> sampleConfigure) {
        sampleConfigure.configureMetrics(configure -> new ThreadPoolRejectMetric(this.collector.getApplicationName(), (String)configure.getSource()));
    }
}

