/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.event;

import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.metrics.event.MetricsEvent;
import org.apache.dubbo.metrics.event.MetricsEventMulticaster;
import org.apache.dubbo.metrics.event.TimeCounterEvent;

public class MetricsEventBus {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(MetricsEventBus.class);

    public static void publish(MetricsEvent event) {
        if (event.getSource() == null) {
            return;
        }
        MetricsEventMulticaster dispatcher = event.getMetricsEventMulticaster();
        Optional.ofNullable(dispatcher).ifPresent(d -> MetricsEventBus.tryInvoke(() -> d.publishEvent(event)));
    }

    public static <T> T post(MetricsEvent event, Supplier<T> targetSupplier) {
        return MetricsEventBus.post(event, targetSupplier, null);
    }

    public static <T> T post(MetricsEvent event, Supplier<T> targetSupplier, Function<T, Boolean> trFunction) {
        Object result;
        MetricsEventBus.tryInvoke(() -> MetricsEventBus.before(event));
        if (trFunction == null) {
            try {
                result = targetSupplier.get();
            }
            catch (Throwable e) {
                MetricsEventBus.tryInvoke(() -> MetricsEventBus.error(event));
                throw e;
            }
            MetricsEventBus.tryInvoke(() -> MetricsEventBus.after(event, result));
        } else {
            result = targetSupplier.get();
            if (trFunction.apply(result).booleanValue()) {
                MetricsEventBus.tryInvoke(() -> MetricsEventBus.after(event, result));
            } else {
                MetricsEventBus.tryInvoke(() -> MetricsEventBus.error(event));
            }
        }
        return result;
    }

    public static void tryInvoke(Runnable runnable) {
        try {
            runnable.run();
        }
        catch (Throwable e) {
            logger.warn("0-13", "", "", "invoke metric event error" + e.getMessage());
        }
    }

    public static void before(MetricsEvent event) {
        MetricsEventMulticaster dispatcher = MetricsEventBus.validate(event);
        if (dispatcher == null) {
            return;
        }
        MetricsEventBus.tryInvoke(() -> dispatcher.publishEvent(event));
    }

    public static void after(MetricsEvent event, Object result) {
        MetricsEventMulticaster dispatcher = MetricsEventBus.validate(event);
        if (dispatcher == null) {
            return;
        }
        MetricsEventBus.tryInvoke(() -> {
            event.customAfterPost(result);
            dispatcher.publishFinishEvent((TimeCounterEvent)event);
        });
    }

    public static void error(MetricsEvent event) {
        MetricsEventMulticaster dispatcher = MetricsEventBus.validate(event);
        if (dispatcher == null) {
            return;
        }
        MetricsEventBus.tryInvoke(() -> dispatcher.publishErrorEvent((TimeCounterEvent)event));
    }

    private static MetricsEventMulticaster validate(MetricsEvent event) {
        MetricsEventMulticaster dispatcher = event.getMetricsEventMulticaster();
        if (dispatcher == null) {
            return null;
        }
        if (!(event instanceof TimeCounterEvent)) {
            return null;
        }
        return dispatcher;
    }
}

