/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.prometheus;

import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.metrics.prometheus.NopPrometheusMetricsReporter;
import org.apache.dubbo.metrics.prometheus.PrometheusMetricsReporter;
import org.apache.dubbo.metrics.report.AbstractMetricsReporterFactory;
import org.apache.dubbo.metrics.report.MetricsReporter;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class PrometheusMetricsReporterFactory
extends AbstractMetricsReporterFactory {
    private final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(PrometheusMetricsReporterFactory.class);

    public PrometheusMetricsReporterFactory(ApplicationModel applicationModel) {
        super(applicationModel);
    }

    public MetricsReporter createMetricsReporter(URL url) {
        try {
            return new PrometheusMetricsReporter(url, this.getApplicationModel());
        }
        catch (NoClassDefFoundError ncde) {
            String msg = ncde.getMessage();
            if (PrometheusMetricsReporterFactory.dependenciesNotFound(msg)) {
                this.logger.error("99-0", "", "", "Failed to load class \"org.apache.dubbo.metrics.prometheus.PrometheusMetricsReporter\".", (Throwable)ncde);
                this.logger.error("99-0", "", "", "Defaulting to no-operation (NOP) metricsReporter implementation", (Throwable)ncde);
                this.logger.error("99-0", "", "", "Introduce the micrometer-core package to use the ability of metrics", (Throwable)ncde);
                return new NopPrometheusMetricsReporter();
            }
            this.logger.error("99-0", "", "", "Failed to instantiate PrometheusMetricsReporter", (Throwable)ncde);
            throw ncde;
        }
    }

    private static boolean dependenciesNotFound(String msg) {
        if (msg == null) {
            return false;
        }
        if (msg.contains("io/micrometer/core/instrument/composite/CompositeMeterRegistry")) {
            return true;
        }
        return msg.contains("io.micrometer.core.instrument.composite.CompositeMeterRegistry");
    }
}

