/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.registry.collector;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.config.context.ConfigManager;
import org.apache.dubbo.metrics.collector.ApplicationMetricsCollector;
import org.apache.dubbo.metrics.data.ApplicationStatComposite;
import org.apache.dubbo.metrics.data.BaseStatComposite;
import org.apache.dubbo.metrics.data.RtStatComposite;
import org.apache.dubbo.metrics.data.ServiceStatComposite;
import org.apache.dubbo.metrics.event.MetricsEvent;
import org.apache.dubbo.metrics.event.MetricsEventMulticaster;
import org.apache.dubbo.metrics.model.MetricsCategory;
import org.apache.dubbo.metrics.model.key.MetricsPlaceType;
import org.apache.dubbo.metrics.model.sample.MetricSample;
import org.apache.dubbo.metrics.registry.RegistryMetricsConstants;
import org.apache.dubbo.metrics.registry.event.RegistryEvent;
import org.apache.dubbo.metrics.registry.event.RegistryMetricsEventMulticaster;
import org.apache.dubbo.metrics.registry.event.type.ApplicationType;
import org.apache.dubbo.metrics.registry.event.type.ServiceType;
import org.apache.dubbo.rpc.model.ApplicationModel;

@Activate
public class RegistryMetricsCollector
implements ApplicationMetricsCollector<ApplicationType, RegistryEvent> {
    private Boolean collectEnabled = null;
    private final BaseStatComposite stats = new BaseStatComposite(){

        protected void init(ApplicationStatComposite applicationStatComposite, ServiceStatComposite serviceStatComposite, RtStatComposite rtStatComposite) {
            applicationStatComposite.init(RegistryMetricsConstants.appKeys);
            serviceStatComposite.init(RegistryMetricsConstants.serviceKeys);
            rtStatComposite.init(new MetricsPlaceType[]{RegistryMetricsConstants.OP_TYPE_REGISTER, RegistryMetricsConstants.OP_TYPE_SUBSCRIBE, RegistryMetricsConstants.OP_TYPE_NOTIFY, RegistryMetricsConstants.OP_TYPE_REGISTER_SERVICE, RegistryMetricsConstants.OP_TYPE_SUBSCRIBE_SERVICE});
        }
    };
    private final MetricsEventMulticaster registryMulticaster = new RegistryMetricsEventMulticaster();
    private final ApplicationModel applicationModel;

    public RegistryMetricsCollector(ApplicationModel applicationModel) {
        this.applicationModel = applicationModel;
    }

    public void setCollectEnabled(Boolean collectEnabled) {
        if (collectEnabled != null) {
            this.collectEnabled = collectEnabled;
        }
    }

    public boolean isCollectEnabled() {
        if (this.collectEnabled == null) {
            ConfigManager configManager = this.applicationModel.getApplicationConfigManager();
            configManager.getMetrics().ifPresent(metricsConfig -> this.setCollectEnabled(metricsConfig.getEnableRegistry()));
        }
        return Optional.ofNullable(this.collectEnabled).orElse(true);
    }

    public void setNum(ServiceType registryType, String applicationName, Map<String, Integer> lastNumMap) {
        lastNumMap.forEach((serviceKey, num) -> this.stats.setServiceKey(registryType.getMetricsKey(), applicationName, serviceKey, num.intValue()));
    }

    public void setNum(ApplicationType registryType, String applicationName, Integer num) {
        this.stats.setApplicationKey(registryType.getMetricsKey(), applicationName, num.intValue());
    }

    public void increment(String applicationName, ApplicationType registryType) {
        this.stats.incrementApp(registryType.getMetricsKey(), applicationName, 1);
    }

    public void incrementServiceKey(String applicationName, String serviceKey, ServiceType registryType, int size) {
        this.stats.incrementServiceKey(registryType.getMetricsKey(), applicationName, serviceKey, size);
    }

    public void addApplicationRT(String applicationName, String registryOpType, Long responseTime) {
        this.stats.calcApplicationRt(applicationName, registryOpType, responseTime);
    }

    public void addServiceKeyRT(String applicationName, String serviceKey, String registryOpType, Long responseTime) {
        this.stats.calcServiceKeyRt(applicationName, serviceKey, registryOpType, responseTime);
    }

    public List<MetricSample> collect() {
        ArrayList<MetricSample> list = new ArrayList<MetricSample>();
        if (!this.isCollectEnabled()) {
            return list;
        }
        list.addAll(this.stats.export(MetricsCategory.REGISTRY));
        return list;
    }

    public boolean isSupport(MetricsEvent event) {
        return event instanceof RegistryEvent;
    }

    public void onEvent(RegistryEvent event) {
        this.registryMulticaster.publishEvent((MetricsEvent)event);
    }

    public void onEventFinish(RegistryEvent event) {
        this.registryMulticaster.publishFinishEvent((MetricsEvent)event);
    }

    public void onEventError(RegistryEvent event) {
        this.registryMulticaster.publishErrorEvent((MetricsEvent)event);
    }
}

