/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.registry.event;

import java.util.function.BiConsumer;
import org.apache.dubbo.metrics.event.MetricsEvent;
import org.apache.dubbo.metrics.listener.MetricsLifeListener;
import org.apache.dubbo.metrics.registry.event.RegistryEvent;

public abstract class RegistryListener
implements MetricsLifeListener<RegistryEvent> {
    private final Object enumType;

    public RegistryListener(Object enumType) {
        this.enumType = enumType;
    }

    public boolean isSupport(MetricsEvent event) {
        return event.isAvailable() && event.isAssignableFrom(this.enumType);
    }

    static <T> RegistryListener onEvent(final T enumType, final BiConsumer<RegistryEvent, T> postFunc) {
        return new RegistryListener(enumType){

            public void onEvent(RegistryEvent event) {
                postFunc.accept(event, enumType);
            }
        };
    }

    static <T> RegistryListener onFinish(final T enumType, final BiConsumer<RegistryEvent, T> finishFunc) {
        return new RegistryListener(enumType){

            public void onEventFinish(RegistryEvent event) {
                finishFunc.accept(event, enumType);
            }
        };
    }

    static <T> RegistryListener onError(final T enumType, final BiConsumer<RegistryEvent, T> errorFunc) {
        return new RegistryListener(enumType){

            public void onEventError(RegistryEvent event) {
                errorFunc.accept(event, enumType);
            }
        };
    }
}

