/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.registry.event;

import java.util.Map;
import org.apache.dubbo.metrics.event.SimpleMetricsEventMulticaster;
import org.apache.dubbo.metrics.listener.MetricsListener;
import org.apache.dubbo.metrics.registry.RegistryMetricsConstants;
import org.apache.dubbo.metrics.registry.event.RegistryEvent;
import org.apache.dubbo.metrics.registry.event.RegistryListener;
import org.apache.dubbo.metrics.registry.event.type.ApplicationType;
import org.apache.dubbo.metrics.registry.event.type.ServiceType;

public final class RegistryMetricsEventMulticaster
extends SimpleMetricsEventMulticaster {
    public RegistryMetricsEventMulticaster() {
        super.addListener((MetricsListener)this.onPostEventBuild(ApplicationType.R_TOTAL));
        super.addListener((MetricsListener)this.onFinishEventBuild(ApplicationType.R_SUCCEED, RegistryMetricsConstants.OP_TYPE_REGISTER.getType()));
        super.addListener((MetricsListener)this.onErrorEventBuild(ApplicationType.R_FAILED, RegistryMetricsConstants.OP_TYPE_REGISTER.getType()));
        super.addListener((MetricsListener)this.onPostEventBuild(ApplicationType.S_TOTAL));
        super.addListener((MetricsListener)this.onFinishEventBuild(ApplicationType.S_SUCCEED, RegistryMetricsConstants.OP_TYPE_SUBSCRIBE.getType()));
        super.addListener((MetricsListener)this.onErrorEventBuild(ApplicationType.S_FAILED, RegistryMetricsConstants.OP_TYPE_SUBSCRIBE.getType()));
        super.addListener((MetricsListener)this.onPostEventBuild(ApplicationType.N_TOTAL));
        super.addListener((MetricsListener)RegistryListener.onFinish(ServiceType.N_LAST_NUM, (event, type) -> {
            event.setLastNum((ServiceType)((Object)type));
            event.addApplicationRT(RegistryMetricsConstants.OP_TYPE_NOTIFY.getType());
        }));
        super.addListener((MetricsListener)RegistryListener.onEvent(ServiceType.D_VALID, (event, type) -> {
            Map summaryMap = (Map)event.getAttachmentValue("dirNum");
            summaryMap.forEach((serviceType, map) -> event.getCollector().setNum((ServiceType)((Object)((Object)serviceType)), event.getSource().getApplicationName(), (Map<String, Integer>)map));
        }));
        super.addListener((MetricsListener)RegistryListener.onEvent(ServiceType.R_SERVICE_TOTAL, this::incrSkSize));
        super.addListener((MetricsListener)RegistryListener.onFinish(ServiceType.R_SERVICE_SUCCEED, this::onRegisterRtEvent));
        super.addListener((MetricsListener)RegistryListener.onError(ServiceType.R_SERVICE_FAILED, this::onRegisterRtEvent));
        super.addListener((MetricsListener)RegistryListener.onEvent(ServiceType.S_SERVICE_TOTAL, this::incrSk));
        super.addListener((MetricsListener)RegistryListener.onFinish(ServiceType.S_SERVICE_SUCCEED, this::onRtEvent));
        super.addListener((MetricsListener)RegistryListener.onError(ServiceType.S_SERVICE_FAILED, this::onRtEvent));
    }

    private RegistryListener onPostEventBuild(ApplicationType applicationType) {
        return RegistryListener.onEvent(applicationType, (event, type) -> event.getCollector().increment(event.getSource().getApplicationName(), (ApplicationType)((Object)type)));
    }

    private RegistryListener onFinishEventBuild(ApplicationType applicationType, String registryOpType) {
        return RegistryListener.onFinish(applicationType, (event, type) -> {
            event.increment((ApplicationType)((Object)type));
            event.addApplicationRT(registryOpType);
        });
    }

    private RegistryListener onErrorEventBuild(ApplicationType applicationType, String registryOpType) {
        return RegistryListener.onError(applicationType, (event, type) -> {
            event.increment((ApplicationType)((Object)type));
            event.addApplicationRT(registryOpType);
        });
    }

    private void incrSk(RegistryEvent event, ServiceType type) {
        event.incrementServiceKey(type, "serviceKey", 1);
    }

    private void incrSkSize(RegistryEvent event, ServiceType type) {
        event.incrementServiceKey(type, "serviceKey", "size");
    }

    private void onRtEvent(RegistryEvent event, ServiceType type) {
        this.incrSk(event, type);
        event.addServiceKeyRT("serviceKey", RegistryMetricsConstants.OP_TYPE_SUBSCRIBE_SERVICE.getType());
    }

    private void onRegisterRtEvent(RegistryEvent event, ServiceType type) {
        this.incrSkSize(event, type);
        event.addServiceKeyRT("serviceKey", RegistryMetricsConstants.OP_TYPE_REGISTER_SERVICE.getType());
    }
}

