/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.registry.event;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.metrics.collector.CombMetricsCollector;
import org.apache.dubbo.metrics.event.MetricsEvent;
import org.apache.dubbo.metrics.listener.AbstractMetricsKeyListener;
import org.apache.dubbo.metrics.model.key.MetricsKey;
import org.apache.dubbo.metrics.model.key.MetricsKeyWrapper;
import org.apache.dubbo.metrics.model.key.MetricsPlaceValue;
import org.apache.dubbo.metrics.registry.RegistryMetricsConstants;
import org.apache.dubbo.metrics.registry.collector.RegistryMetricsCollector;

public class RegistrySpecListener {
    public static AbstractMetricsKeyListener onPost(MetricsKey metricsKey, CombMetricsCollector<?> collector) {
        return AbstractMetricsKeyListener.onEvent((MetricsKey)metricsKey, event -> ((RegistryMetricsCollector)collector).incrMetricsNum(metricsKey, RegistrySpecListener.getRgs((MetricsEvent)event)));
    }

    public static AbstractMetricsKeyListener onFinish(MetricsKey metricsKey, CombMetricsCollector<?> collector) {
        return AbstractMetricsKeyListener.onFinish((MetricsKey)metricsKey, (T event) -> ((RegistryMetricsCollector)collector).incrRegisterFinishNum(metricsKey, RegistryMetricsConstants.OP_TYPE_REGISTER.getType(), RegistrySpecListener.getRgs((MetricsEvent)event), event.getTimePair().calc()));
    }

    public static AbstractMetricsKeyListener onError(MetricsKey metricsKey, CombMetricsCollector<?> collector) {
        return AbstractMetricsKeyListener.onError((MetricsKey)metricsKey, (T event) -> ((RegistryMetricsCollector)collector).incrRegisterFinishNum(metricsKey, RegistryMetricsConstants.OP_TYPE_REGISTER.getType(), RegistrySpecListener.getRgs((MetricsEvent)event), event.getTimePair().calc()));
    }

    public static AbstractMetricsKeyListener onPostOfService(MetricsKey metricsKey, MetricsPlaceValue placeType, CombMetricsCollector<?> collector) {
        return AbstractMetricsKeyListener.onEvent((MetricsKey)metricsKey, event -> ((RegistryMetricsCollector)collector).incrServiceRegisterNum(new MetricsKeyWrapper(metricsKey, placeType), RegistrySpecListener.getServiceKey((MetricsEvent)event), RegistrySpecListener.getRgs((MetricsEvent)event), RegistrySpecListener.getSize((MetricsEvent)event)));
    }

    public static AbstractMetricsKeyListener onFinishOfService(MetricsKey metricsKey, MetricsPlaceValue placeType, CombMetricsCollector<?> collector) {
        return AbstractMetricsKeyListener.onFinish((MetricsKey)metricsKey, (T event) -> ((RegistryMetricsCollector)collector).incrServiceRegisterFinishNum(new MetricsKeyWrapper(metricsKey, placeType), RegistrySpecListener.getServiceKey((MetricsEvent)event), RegistrySpecListener.getRgs((MetricsEvent)event), RegistrySpecListener.getSize((MetricsEvent)event), event.getTimePair().calc()));
    }

    public static AbstractMetricsKeyListener onErrorOfService(MetricsKey metricsKey, MetricsPlaceValue placeType, CombMetricsCollector<?> collector) {
        return AbstractMetricsKeyListener.onError((MetricsKey)metricsKey, (T event) -> ((RegistryMetricsCollector)collector).incrServiceRegisterFinishNum(new MetricsKeyWrapper(metricsKey, placeType), RegistrySpecListener.getServiceKey((MetricsEvent)event), RegistrySpecListener.getRgs((MetricsEvent)event), RegistrySpecListener.getSize((MetricsEvent)event), event.getTimePair().calc()));
    }

    public static AbstractMetricsKeyListener onFinishOfNotify(MetricsKey metricsKey, MetricsPlaceValue placeType, CombMetricsCollector<?> collector) {
        return AbstractMetricsKeyListener.onFinish((MetricsKey)metricsKey, (T event) -> {
            collector.addServiceRt(event.appName(), placeType.getType(), Long.valueOf(event.getTimePair().calc()));
            Map<String, Integer> lastNumMap = Collections.unmodifiableMap((Map)event.getAttachmentValue("lastNumMap"));
            lastNumMap.forEach((k, v) -> collector.setNum(new MetricsKeyWrapper(metricsKey, RegistryMetricsConstants.OP_TYPE_NOTIFY), k, v.intValue()));
        });
    }

    public static AbstractMetricsKeyListener onPostOfDirectory(MetricsKey metricsKey, CombMetricsCollector<?> collector) {
        return AbstractMetricsKeyListener.onEvent((MetricsKey)metricsKey, event -> {
            Map summaryMap = (Map)event.getAttachmentValue("dirNum");
            HashMap<String, String> otherAttachments = new HashMap<String, String>();
            for (Map.Entry entry : event.getAttachments().entrySet()) {
                if (!(entry.getValue() instanceof String)) continue;
                otherAttachments.put(((String)entry.getKey()).toLowerCase(Locale.ROOT), (String)entry.getValue());
            }
            summaryMap.forEach((summaryKey, map) -> map.forEach((k, v) -> {
                if (CollectionUtils.isEmptyMap((Map)otherAttachments)) {
                    collector.setNum(new MetricsKeyWrapper(summaryKey, RegistryMetricsConstants.OP_TYPE_DIRECTORY), k, v.intValue());
                } else {
                    ((RegistryMetricsCollector)collector).setNum(new MetricsKeyWrapper(summaryKey, RegistryMetricsConstants.OP_TYPE_DIRECTORY), (String)k, (int)v, otherAttachments);
                }
            }));
        });
    }

    public static List<String> getRgs(MetricsEvent event) {
        return (List)event.getAttachmentValue("registryKey");
    }

    public static int getSize(MetricsEvent event) {
        return (Integer)event.getAttachmentValue("size");
    }

    public static String getServiceKey(MetricsEvent event) {
        return (String)event.getAttachmentValue("serviceKey");
    }
}

