/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.aot.generate;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.dubbo.aot.api.ResourceBundleDescriber;
import org.apache.dubbo.aot.api.ResourcePatternDescriber;

public class ResourceConfigMetadataRepository {
    private final List<ResourcePatternDescriber> includes = new ArrayList<ResourcePatternDescriber>();
    private final List<ResourcePatternDescriber> excludes = new ArrayList<ResourcePatternDescriber>();
    private final Set<ResourceBundleDescriber> resourceBundles = new LinkedHashSet<ResourceBundleDescriber>();

    public ResourceConfigMetadataRepository registerIncludesPatterns(String ... patterns) {
        for (String pattern : patterns) {
            this.registerIncludesPattern(new ResourcePatternDescriber(pattern, null));
        }
        return this;
    }

    public ResourceConfigMetadataRepository registerIncludesPattern(ResourcePatternDescriber describer) {
        this.includes.add(describer);
        return this;
    }

    public ResourceConfigMetadataRepository registerExcludesPattern(ResourcePatternDescriber describer) {
        this.excludes.add(describer);
        return this;
    }

    public ResourceConfigMetadataRepository registerBundles(ResourceBundleDescriber describer) {
        this.resourceBundles.add(describer);
        return this;
    }

    public List<ResourcePatternDescriber> getIncludes() {
        return this.includes;
    }

    public List<ResourcePatternDescriber> getExcludes() {
        return this.excludes;
    }

    public Set<ResourceBundleDescriber> getResourceBundles() {
        return this.resourceBundles;
    }
}

