/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.qos.command.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.AbstractInterfaceConfig;
import org.apache.dubbo.config.bootstrap.DubboBootstrap;
import org.apache.dubbo.config.utils.ConfigValidationUtils;
import org.apache.dubbo.qos.command.BaseCommand;
import org.apache.dubbo.qos.command.CommandContext;
import org.apache.dubbo.qos.command.annotation.Cmd;
import org.apache.dubbo.qos.textui.TTable;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.ProviderModel;

@Cmd(name="ready", summary="Judge if application or service has started? ")
public class Ready
implements BaseCommand {
    @Override
    public String execute(CommandContext commandContext, String[] args) {
        String serviceName;
        String string = serviceName = args.length > 0 ? args[0] : null;
        if (StringUtils.isEmpty((String)serviceName)) {
            return DubboBootstrap.getInstance().isReady() ? "true" : "false";
        }
        Map<String, Boolean> serviceReadyMap = this.isServiceReady(serviceName);
        if (serviceReadyMap == null || serviceReadyMap.size() <= 0) {
            return "can't match service=" + serviceName;
        }
        return this.buildUiText(serviceReadyMap);
    }

    private String buildUiText(Map<String, Boolean> serviceReadyMap) {
        TTable tTable = new TTable(new TTable.ColumnDefine[]{new TTable.ColumnDefine(TTable.Align.MIDDLE), new TTable.ColumnDefine(TTable.Align.MIDDLE)});
        tTable.addRow("Provider Service Name", "STATUS");
        for (Map.Entry<String, Boolean> entry : serviceReadyMap.entrySet()) {
            String status = Boolean.TRUE.equals(entry.getValue()) ? "TRUE" : "FALSE";
            tTable.addRow(entry.getKey(), status);
        }
        return tTable.rendering();
    }

    private Map<String, Boolean> isServiceReady(String serviceName) {
        HashMap<String, Boolean> res = new HashMap<String, Boolean>();
        for (ProviderModel providerModel : ApplicationModel.allProviderModels()) {
            String serviceKey = providerModel.getServiceKey();
            String interfaceName = providerModel.getServiceConfig().getInterface();
            if (!interfaceName.equals(serviceName)) continue;
            List needRegistryURLs = ConfigValidationUtils.loadRegistries((AbstractInterfaceConfig)providerModel.getServiceConfig(), (boolean)true);
            List registeredRegistryURLs = providerModel.getStatedUrl().stream().filter(x -> Boolean.TRUE.equals(x.isRegistered())).map(ProviderModel.RegisterStatedURL::getRegistryUrl).collect(Collectors.toList());
            if (needRegistryURLs.size() == registeredRegistryURLs.size()) {
                res.put(serviceKey, true);
                continue;
            }
            res.put(serviceKey, false);
        }
        return res;
    }
}

