/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.qos.command.impl;

import java.util.List;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.ArrayUtils;
import org.apache.dubbo.qos.command.BaseCommand;
import org.apache.dubbo.qos.command.CommandContext;
import org.apache.dubbo.qos.command.annotation.Cmd;
import org.apache.dubbo.registry.Registry;
import org.apache.dubbo.registry.RegistryFactory;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.ProviderModel;
import org.apache.dubbo.rpc.model.ServiceRepository;

@Cmd(name="online", summary="online dubbo", example={"online dubbo", "online xx.xx.xxx.service"})
public class Online
implements BaseCommand {
    private static final Logger logger = LoggerFactory.getLogger(Online.class);
    private static RegistryFactory registryFactory = (RegistryFactory)ExtensionLoader.getExtensionLoader(RegistryFactory.class).getAdaptiveExtension();
    private static ServiceRepository serviceRepository = ApplicationModel.getServiceRepository();

    @Override
    public String execute(CommandContext commandContext, String[] args) {
        boolean hasService;
        logger.info("receive online command");
        String servicePattern = ".*";
        if (ArrayUtils.isNotEmpty((Object[])args)) {
            servicePattern = args[0];
        }
        if (hasService = Online.online(servicePattern)) {
            return "OK";
        }
        return "service not found";
    }

    public static boolean online(String servicePattern) {
        boolean hasService = false;
        List providerModelList = serviceRepository.getExportedServices();
        for (ProviderModel providerModel : providerModelList) {
            if (!providerModel.getServiceName().matches(servicePattern)) continue;
            hasService = true;
            List statedUrls = providerModel.getStatedUrl();
            for (ProviderModel.RegisterStatedURL statedURL : statedUrls) {
                if (statedURL.isRegistered()) continue;
                Registry registry = registryFactory.getRegistry(statedURL.getRegistryUrl());
                registry.register(statedURL.getProviderUrl());
                statedURL.setRegistered(true);
            }
        }
        return hasService;
    }
}

