/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.qos.command.impl;

import java.util.List;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.qos.command.BaseCommand;
import org.apache.dubbo.qos.command.CommandContext;
import org.apache.dubbo.qos.command.impl.OfflineInterface;
import org.apache.dubbo.registry.Registry;
import org.apache.dubbo.registry.RegistryFactory;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.ProviderModel;
import org.apache.dubbo.rpc.model.ServiceMetadata;
import org.apache.dubbo.rpc.model.ServiceRepository;

public class BaseOffline
implements BaseCommand {
    private Logger logger = LoggerFactory.getLogger(OfflineInterface.class);
    public static RegistryFactory registryFactory = (RegistryFactory)ExtensionLoader.getExtensionLoader(RegistryFactory.class).getAdaptiveExtension();
    public static ServiceRepository serviceRepository = ApplicationModel.getServiceRepository();

    @Override
    public String execute(CommandContext commandContext, String[] args) {
        boolean hasService;
        this.logger.info("receive offline command");
        String servicePattern = ".*";
        if (args != null && args.length > 0) {
            servicePattern = args[0];
        }
        if (hasService = this.doExecute(servicePattern)) {
            return "OK";
        }
        return "service not found";
    }

    protected boolean doExecute(String servicePattern) {
        return this.offline(servicePattern);
    }

    public boolean offline(String servicePattern) {
        boolean hasService = false;
        List providerModelList = serviceRepository.getExportedServices();
        for (ProviderModel providerModel : providerModelList) {
            ServiceMetadata metadata = providerModel.getServiceMetadata();
            if (!metadata.getServiceKey().matches(servicePattern) && !metadata.getDisplayServiceKey().matches(servicePattern)) continue;
            hasService = true;
            List statedUrls = providerModel.getStatedUrl();
            for (ProviderModel.RegisterStatedURL statedURL : statedUrls) {
                if (!statedURL.isRegistered()) continue;
                this.doUnexport(statedURL);
            }
        }
        return hasService;
    }

    protected void doUnexport(ProviderModel.RegisterStatedURL statedURL) {
        Registry registry = registryFactory.getRegistry(statedURL.getRegistryUrl());
        registry.unregister(statedURL.getProviderUrl());
        statedURL.setRegistered(false);
    }
}

