/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.qos.command.util;

import java.util.Collection;
import java.util.Map;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.registry.support.AbstractRegistry;
import org.apache.dubbo.registry.support.RegistryManager;
import org.apache.dubbo.rpc.model.ConsumerModel;
import org.apache.dubbo.rpc.model.ProviderModel;

public class ServiceCheckUtils {
    public static boolean isRegistered(ProviderModel providerModel) {
        for (ProviderModel.RegisterStatedURL registerStatedURL : providerModel.getStatedUrl()) {
            if (!registerStatedURL.isRegistered()) continue;
            return true;
        }
        return false;
    }

    public static int getConsumerAddressNum(ConsumerModel consumerModel) {
        int num = 0;
        RegistryManager registryManager = (RegistryManager)consumerModel.getModuleModel().getApplicationModel().getBeanFactory().getBean(RegistryManager.class);
        Collection registries = registryManager.getRegistries();
        if (CollectionUtils.isNotEmpty((Collection)registries)) {
            AbstractRegistry abstractRegistry = (AbstractRegistry)registries.iterator().next();
            for (Map.Entry entry : abstractRegistry.getNotified().entrySet()) {
                if (!((URL)entry.getKey()).getServiceKey().equals(consumerModel.getServiceKey()) || !CollectionUtils.isNotEmptyMap((Map)((Map)entry.getValue()))) continue;
                num = ((Map)entry.getValue()).size();
            }
        }
        return num;
    }
}

