/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.qos.textui;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.qos.textui.TComponent;

public class TTree
implements TComponent {
    private static final String STEP_FIRST_CHAR = "`---";
    private static final String STEP_NORMAL_CHAR = "+---";
    private static final String STEP_HAS_BOARD = "|   ";
    private static final String STEP_EMPTY_BOARD = "    ";
    private final boolean isPrintCost;
    private final Node root;
    private Node current;

    public TTree(boolean isPrintCost, String title) {
        this.current = this.root = new Node(title).markBegin().markEnd();
        this.isPrintCost = isPrintCost;
    }

    @Override
    public String rendering() {
        final StringBuilder treeSB = new StringBuilder();
        this.recursive(0, true, "", this.root, new Callback(){

            @Override
            public void callback(int deep, boolean isLast, String prefix, Node node) {
                boolean hasChild = !node.children.isEmpty();
                String stepString = isLast ? TTree.STEP_FIRST_CHAR : TTree.STEP_NORMAL_CHAR;
                int stepStringLength = StringUtils.length((CharSequence)stepString);
                treeSB.append(prefix).append(stepString);
                int costPrefixLength = 0;
                if (hasChild) {
                    treeSB.append('+');
                }
                if (TTree.this.isPrintCost && !node.isRoot()) {
                    String costPrefix = String.format("[%s,%sms]", node.endTimestamp - TTree.this.root.beginTimestamp, node.endTimestamp - node.beginTimestamp);
                    costPrefixLength = StringUtils.length((CharSequence)costPrefix);
                    treeSB.append(costPrefix);
                }
                try (Scanner scanner = new Scanner(new StringReader(node.data.toString()));){
                    boolean isFirst = true;
                    while (scanner.hasNextLine()) {
                        if (isFirst) {
                            treeSB.append(scanner.nextLine()).append('\n');
                            isFirst = false;
                            continue;
                        }
                        treeSB.append(prefix).append(StringUtils.repeat((char)' ', (int)stepStringLength)).append(hasChild ? "|" : "").append(StringUtils.repeat((char)' ', (int)costPrefixLength)).append(scanner.nextLine()).append(System.lineSeparator());
                    }
                }
            }
        });
        return treeSB.toString();
    }

    private void recursive(int deep, boolean isLast, String prefix, Node node, Callback callback) {
        callback.callback(deep, isLast, prefix, node);
        if (!node.isLeaf()) {
            int size = node.children.size();
            for (int index = 0; index < size; ++index) {
                boolean isLastFlag = index == size - 1;
                String currentPrefix = isLast ? prefix + STEP_EMPTY_BOARD : prefix + STEP_HAS_BOARD;
                this.recursive(deep + 1, isLastFlag, currentPrefix, node.children.get(index), callback);
            }
        }
    }

    public boolean isTop() {
        return this.current.isRoot();
    }

    public TTree begin(Object data) {
        this.current = new Node(this.current, data);
        this.current.markBegin();
        return this;
    }

    public TTree begin() {
        return this.begin(null);
    }

    public Object get() {
        if (this.current.isRoot()) {
            throw new IllegalStateException("current node is root.");
        }
        return this.current.data;
    }

    public TTree set(Object data) {
        if (this.current.isRoot()) {
            throw new IllegalStateException("current node is root.");
        }
        this.current.data = data;
        return this;
    }

    public TTree end() {
        if (this.current.isRoot()) {
            throw new IllegalStateException("current node is root.");
        }
        this.current.markEnd();
        this.current = this.current.parent;
        return this;
    }

    private static interface Callback {
        public void callback(int var1, boolean var2, String var3, Node var4);
    }

    private static class Node {
        final Node parent;
        Object data;
        final List<Node> children = new ArrayList<Node>();
        private long beginTimestamp;
        private long endTimestamp;

        private Node(Object data) {
            this.parent = null;
            this.data = data;
        }

        private Node(Node parent, Object data) {
            this.parent = parent;
            this.data = data;
            parent.children.add(this);
        }

        boolean isRoot() {
            return null == this.parent;
        }

        boolean isLeaf() {
            return this.children.isEmpty();
        }

        Node markBegin() {
            this.beginTimestamp = System.currentTimeMillis();
            return this;
        }

        Node markEnd() {
            this.endTimestamp = System.currentTimeMillis();
            return this;
        }
    }
}

