/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.qos.server.handler;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.LineBasedFrameDecoder;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.string.StringDecoder;
import io.netty.handler.codec.string.StringEncoder;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.ScheduledFuture;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.utils.ExecutorUtil;
import org.apache.dubbo.qos.server.handler.ForeignHostPermitHandler;
import org.apache.dubbo.qos.server.handler.HttpProcessHandler;
import org.apache.dubbo.qos.server.handler.TelnetIdleEventHandler;
import org.apache.dubbo.qos.server.handler.TelnetProcessHandler;
import org.apache.dubbo.rpc.model.FrameworkModel;

public class QosProcessHandler
extends ByteToMessageDecoder {
    private ScheduledFuture<?> welcomeFuture;
    private String welcome;
    private boolean acceptForeignIp;
    private String acceptForeignIpWhitelist;
    private FrameworkModel frameworkModel;
    public static final String PROMPT = "dubbo>";

    public QosProcessHandler(FrameworkModel frameworkModel, String welcome, boolean acceptForeignIp, String acceptForeignIpWhitelist) {
        this.frameworkModel = frameworkModel;
        this.welcome = welcome;
        this.acceptForeignIp = acceptForeignIp;
        this.acceptForeignIpWhitelist = acceptForeignIpWhitelist;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.welcomeFuture = ctx.executor().schedule(() -> {
            if (this.welcome != null) {
                ctx.write((Object)Unpooled.wrappedBuffer((byte[])this.welcome.getBytes()));
                ctx.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])PROMPT.getBytes()));
            }
        }, 500L, TimeUnit.MILLISECONDS);
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (in.readableBytes() < 1) {
            return;
        }
        byte magic = in.getByte(in.readerIndex());
        ChannelPipeline p = ctx.pipeline();
        p.addLast(new ChannelHandler[]{new ForeignHostPermitHandler(this.acceptForeignIp, this.acceptForeignIpWhitelist)});
        if (QosProcessHandler.isHttp(magic)) {
            if (this.welcomeFuture != null && this.welcomeFuture.isCancellable()) {
                this.welcomeFuture.cancel(false);
            }
            p.addLast(new ChannelHandler[]{new HttpServerCodec()});
            p.addLast(new ChannelHandler[]{new HttpObjectAggregator(0x100000)});
            p.addLast(new ChannelHandler[]{new HttpProcessHandler(this.frameworkModel)});
            p.remove((ChannelHandler)this);
        } else {
            p.addLast(new ChannelHandler[]{new LineBasedFrameDecoder(2048)});
            p.addLast(new ChannelHandler[]{new StringDecoder(CharsetUtil.UTF_8)});
            p.addLast(new ChannelHandler[]{new StringEncoder(CharsetUtil.UTF_8)});
            p.addLast(new ChannelHandler[]{new IdleStateHandler(0, 0, 300)});
            p.addLast(new ChannelHandler[]{new TelnetIdleEventHandler()});
            p.addLast(new ChannelHandler[]{new TelnetProcessHandler(this.frameworkModel)});
            p.remove((ChannelHandler)this);
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            ExecutorUtil.cancelScheduledFuture(this.welcomeFuture);
            ctx.close();
        }
    }

    private static boolean isHttp(int magic) {
        return magic == 71 || magic == 80;
    }
}

