/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.qos.command;

import io.netty.channel.Channel;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.qos.command.BaseCommand;
import org.apache.dubbo.qos.command.CommandContext;
import org.apache.dubbo.qos.command.CommandExecutor;
import org.apache.dubbo.qos.command.NoSuchCommandException;
import org.apache.dubbo.rpc.model.FrameworkModel;

public class DefaultCommandExecutor
implements CommandExecutor {
    private static final Logger logger = LoggerFactory.getLogger(DefaultCommandExecutor.class);
    private FrameworkModel frameworkModel;

    public DefaultCommandExecutor(FrameworkModel frameworkModel) {
        this.frameworkModel = frameworkModel;
    }

    @Override
    public String execute(CommandContext commandContext) throws NoSuchCommandException {
        String remoteAddress = Optional.ofNullable(commandContext.getRemote()).map(Channel::remoteAddress).map(Objects::toString).orElse("unknown");
        logger.info("[Dubbo QoS] Command Process start. Command: " + commandContext.getCommandName() + ", Args: " + Arrays.toString(commandContext.getArgs()) + ", Remote Address: " + remoteAddress);
        BaseCommand command = null;
        try {
            command = (BaseCommand)this.frameworkModel.getExtensionLoader(BaseCommand.class).getExtension(commandContext.getCommandName());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (command == null) {
            logger.info("[Dubbo QoS] Command Not found. Command: " + commandContext.getCommandName() + ", Remote Address: " + remoteAddress);
            throw new NoSuchCommandException(commandContext.getCommandName());
        }
        try {
            String result = command.execute(commandContext, commandContext.getArgs());
            logger.info("[Dubbo QoS] Command Process success. Command: " + commandContext.getCommandName() + ", Args: " + Arrays.toString(commandContext.getArgs()) + ", Result: " + result + ", Remote Address: " + remoteAddress);
            return result;
        }
        catch (Throwable t) {
            logger.info("[Dubbo QoS] Command Process Failed. Command: " + commandContext.getCommandName() + ", Args: " + Arrays.toString(commandContext.getArgs()) + ", Remote Address: " + remoteAddress, t);
            throw t;
        }
    }
}

