/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.qos.common;

import org.apache.dubbo.qos.permission.PermissionLevel;

public class QosConfiguration {
    private String welcome;
    private boolean acceptForeignIp;
    private String acceptForeignIpWhitelist;
    private PermissionLevel anonymousAccessPermissionLevel = PermissionLevel.PUBLIC;

    private QosConfiguration() {
    }

    public QosConfiguration(Builder builder) {
        this.welcome = builder.getWelcome();
        this.acceptForeignIp = builder.isAcceptForeignIp();
        this.acceptForeignIpWhitelist = builder.getAcceptForeignIpWhitelist();
        this.anonymousAccessPermissionLevel = builder.getAnonymousAccessPermissionLevel();
    }

    public boolean isAllowAnonymousAccess() {
        return PermissionLevel.NONE != this.anonymousAccessPermissionLevel;
    }

    public String getWelcome() {
        return this.welcome;
    }

    public PermissionLevel getAnonymousAccessPermissionLevel() {
        return this.anonymousAccessPermissionLevel;
    }

    public String getAcceptForeignIpWhitelist() {
        return this.acceptForeignIpWhitelist;
    }

    public boolean isAcceptForeignIp() {
        return this.acceptForeignIp;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String welcome;
        private boolean acceptForeignIp;
        private String acceptForeignIpWhitelist;
        private PermissionLevel anonymousAccessPermissionLevel = PermissionLevel.PUBLIC;

        private Builder() {
        }

        public Builder welcome(String welcome) {
            this.welcome = welcome;
            return this;
        }

        public Builder acceptForeignIp(boolean acceptForeignIp) {
            this.acceptForeignIp = acceptForeignIp;
            return this;
        }

        public Builder acceptForeignIpWhitelist(String acceptForeignIpWhitelist) {
            this.acceptForeignIpWhitelist = acceptForeignIpWhitelist;
            return this;
        }

        public Builder anonymousAccessPermissionLevel(String anonymousAccessPermissionLevel) {
            this.anonymousAccessPermissionLevel = PermissionLevel.from(anonymousAccessPermissionLevel);
            return this;
        }

        public QosConfiguration build() {
            return new QosConfiguration(this);
        }

        public String getWelcome() {
            return this.welcome;
        }

        public boolean isAcceptForeignIp() {
            return this.acceptForeignIp;
        }

        public String getAcceptForeignIpWhitelist() {
            return this.acceptForeignIpWhitelist;
        }

        public PermissionLevel getAnonymousAccessPermissionLevel() {
            return this.anonymousAccessPermissionLevel;
        }
    }
}

