/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.qos.permission;

import java.util.Arrays;
import org.apache.dubbo.common.utils.StringUtils;

public enum PermissionLevel {
    PUBLIC(1),
    PROTECTED(2),
    PRIVATE(3),
    NONE(Integer.MIN_VALUE);

    private final int level;

    private PermissionLevel(int level) {
        this.level = level;
    }

    public int getLevel() {
        return this.level;
    }

    public static PermissionLevel from(String permissionLevel) {
        if (StringUtils.isNumber((String)permissionLevel)) {
            return Arrays.stream(PermissionLevel.values()).filter(p -> String.valueOf(p.getLevel()).equals(permissionLevel.trim())).findFirst().orElse(PUBLIC);
        }
        return Arrays.stream(PermissionLevel.values()).filter(p -> p.name().equalsIgnoreCase(String.valueOf(permissionLevel).trim())).findFirst().orElse(PUBLIC);
    }
}

